/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.block.AnomalyBlock;
import biomesoplenty.init.ModTags;
import biomesoplenty.util.SimpleBlockPredicate;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class AnomalyFeature
extends Feature<NoneFeatureConfiguration> {
    protected SimpleBlockPredicate placeOn = (world, pos) -> world.getBlockState(pos).getBlock() == Blocks.END_STONE || world.getBlockState(pos).getBlock() == BOPBlocks.UNMAPPED_END_STONE;
    protected SimpleBlockPredicate replace = (world, pos) -> world.getBlockState(pos).is(BlockTags.REPLACEABLE_BY_TREES) || world.getBlockState(pos).getBlock() instanceof BushBlock || world.getBlockState(pos).is(ModTags.Blocks.NULL_REPLACEABLE);

    public AnomalyFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        int z;
        int x;
        int y;
        int anomalyHeight;
        WorldGenLevel world = featurePlaceContext.level();
        ChunkGenerator chunkGenerator = featurePlaceContext.chunkGenerator();
        RandomSource rand = featurePlaceContext.random();
        BlockPos startPos = featurePlaceContext.origin();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.config();
        while (startPos.getY() >= world.getMinY() + 1 && !this.placeOn.matches(world, startPos)) {
            startPos = startPos.below();
        }
        if (!this.placeOn.matches(world, startPos.offset(0, 0, 0))) {
            return false;
        }
        int size = rand.nextInt(4) + 3;
        if (!this.checkSpace(world, startPos, size, anomalyHeight = rand.nextInt(8) + 2)) {
            return false;
        }
        BlockPos pos = startPos;
        for (y = 6; y > -128; --y) {
            for (x = -3; x <= size + 3; ++x) {
                for (z = -3; z <= size + 3; ++z) {
                    if (x == -3 || x == size + 3 || z == -3 || z == size + 3) {
                        if ((x == -3 || x == size + 3) && (z == -3 || z == size + 3) || rand.nextInt(4) != 0 || world.getBlockState(pos.offset(x, y, z)).getBlock() == BOPBlocks.NULL_BLOCK) continue;
                        if (world.getBlockState(pos.offset(x, y, z)).is(BlockTags.REPLACEABLE_BY_TREES)) {
                            this.setBlock(world, pos.offset(x, y, z), Blocks.AIR.defaultBlockState());
                            continue;
                        }
                        this.setBlock(world, pos.offset(x, y, z), BOPBlocks.NULL_END_STONE.defaultBlockState());
                        continue;
                    }
                    if (x == -2 || x == size + 2 || z == -2 || z == size + 2) {
                        if ((x == -2 || x == size + 2) && (z == -2 || z == size + 2) || world.getBlockState(pos.offset(x, y, z)).getBlock() == BOPBlocks.NULL_BLOCK) continue;
                        if (world.getBlockState(pos.offset(x, y, z)).is(BlockTags.REPLACEABLE_BY_TREES)) {
                            this.setBlock(world, pos.offset(x, y, z), Blocks.AIR.defaultBlockState());
                            continue;
                        }
                        if (rand.nextInt(4) == 0) {
                            this.setBlock(world, pos.offset(x, y, z), BOPBlocks.NULL_BLOCK.defaultBlockState());
                            continue;
                        }
                        this.setBlock(world, pos.offset(x, y, z), BOPBlocks.NULL_END_STONE.defaultBlockState());
                        continue;
                    }
                    if (x == -1 || x == size + 1 || z == -1 || z == size + 1) {
                        if (!(x != -1 && x != size + 1 || z != -1 && z != size + 1)) {
                            if (world.getBlockState(pos.offset(x, y, z)).is(BlockTags.REPLACEABLE_BY_TREES)) {
                                this.setBlock(world, pos.offset(x, y, z), Blocks.AIR.defaultBlockState());
                                continue;
                            }
                            this.setBlock(world, pos.offset(x, y, z), BOPBlocks.NULL_END_STONE.defaultBlockState());
                            continue;
                        }
                        if (world.getBlockState(pos.offset(x, y, z)).is(BlockTags.REPLACEABLE_BY_TREES)) {
                            this.setBlock(world, pos.offset(x, y, z), Blocks.AIR.defaultBlockState());
                            continue;
                        }
                        this.setBlock(world, pos.offset(x, y, z), BOPBlocks.NULL_BLOCK.defaultBlockState());
                        continue;
                    }
                    this.setBlock(world, pos.offset(x, y, z), Blocks.AIR.defaultBlockState());
                }
            }
        }
        for (y = 0; y <= size; ++y) {
            for (x = 0; x <= size; ++x) {
                for (z = 0; z <= size; ++z) {
                    AnomalyBlock.AnomalyType type = AnomalyBlock.AnomalyType.STABLE;
                    if (y == 0 || y == size || x == 0 || x == size || z == 0 || z == size) {
                        switch (rand.nextInt(5)) {
                            default: {
                                type = AnomalyBlock.AnomalyType.VOLATILE;
                                break;
                            }
                            case 1: {
                                type = AnomalyBlock.AnomalyType.QUIRKY;
                                break;
                            }
                            case 2: {
                                type = AnomalyBlock.AnomalyType.UNSTABLE;
                            }
                        }
                    }
                    world.setBlock(pos.offset(x, anomalyHeight + y, z), (BlockState)BOPBlocks.ANOMALY.defaultBlockState().setValue(AnomalyBlock.ANOMALY_TYPE, (Comparable)((Object)type)), 2);
                }
            }
        }
        return true;
    }

    public boolean setBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            super.setBlock((LevelWriter)world, pos, state);
            return true;
        }
        return false;
    }

    public boolean checkSpace(WorldGenLevel world, BlockPos pos, int size, int anomalyHeight) {
        for (int y = 0; y <= size; ++y) {
            for (int x = 0; x <= size; ++x) {
                for (int z = 0; z <= size; ++z) {
                    BlockPos pos1 = pos.offset(x, anomalyHeight + y, z);
                    if (pos1.getY() < 255 && (world.getBlockState(pos1).isAir() || world.getBlockState(pos1).getBlock() == BOPBlocks.ANOMALY)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

