/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.init;

import biomesoplenty.api.block.BOPBlockSetTypes;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BOPFluids;
import biomesoplenty.api.block.BOPWoodTypes;
import biomesoplenty.api.sound.BOPSounds;
import biomesoplenty.block.AlgalEndStoneBlock;
import biomesoplenty.block.AnomalyBlock;
import biomesoplenty.block.BarnaclesBlock;
import biomesoplenty.block.BlackstoneDecorationBlock;
import biomesoplenty.block.BloodBlock;
import biomesoplenty.block.BrambleBlock;
import biomesoplenty.block.BrambleLeavesBlock;
import biomesoplenty.block.BrimstoneBudBlock;
import biomesoplenty.block.BrimstoneClusterBlock;
import biomesoplenty.block.BrimstoneFumaroleBlock;
import biomesoplenty.block.CeilingHangingSignBlockBOP;
import biomesoplenty.block.CloverBlock;
import biomesoplenty.block.DeadBranchBlock;
import biomesoplenty.block.DoublePlantBlockBOP;
import biomesoplenty.block.DoubleWaterPlantBlock;
import biomesoplenty.block.DoubleWatersidePlantBlock;
import biomesoplenty.block.DriedSaltBlock;
import biomesoplenty.block.EyebulbBlock;
import biomesoplenty.block.FleshBlock;
import biomesoplenty.block.FleshTendonsBlock;
import biomesoplenty.block.FleshTendonsBottomBlock;
import biomesoplenty.block.FlowerBedBlockBOP;
import biomesoplenty.block.FlowerBlockBOP;
import biomesoplenty.block.FoliageBlockBOP;
import biomesoplenty.block.GlowingMossBlock;
import biomesoplenty.block.GlowwormSilkBlock;
import biomesoplenty.block.GlowwormSilkBottomBlock;
import biomesoplenty.block.HairBlock;
import biomesoplenty.block.HangingCobwebBlock;
import biomesoplenty.block.HangingCobwebBottomBlock;
import biomesoplenty.block.HighGrassBlock;
import biomesoplenty.block.HighGrassPlantBlock;
import biomesoplenty.block.HugeCloverPetalBlock;
import biomesoplenty.block.HugeLilyPadBlock;
import biomesoplenty.block.LumaloopBlock;
import biomesoplenty.block.LumaloopPlantBlock;
import biomesoplenty.block.MushroomBlockBOP;
import biomesoplenty.block.NullBlock;
import biomesoplenty.block.NullLeavesBlock;
import biomesoplenty.block.NullPlantBlock;
import biomesoplenty.block.OriginGrassBlock;
import biomesoplenty.block.OvergrownSandBlock;
import biomesoplenty.block.PurpleWildflowerBlock;
import biomesoplenty.block.PusBubbleBlock;
import biomesoplenty.block.SandBlockBOP;
import biomesoplenty.block.SaplingBlockBOP;
import biomesoplenty.block.SeaOatsBlock;
import biomesoplenty.block.SpanishMossBlock;
import biomesoplenty.block.SpanishMossBottomBlock;
import biomesoplenty.block.SpiderEggBlock;
import biomesoplenty.block.StandingSignBlockBOP;
import biomesoplenty.block.StringyCobwebBlock;
import biomesoplenty.block.TallFlowerBlockBOP;
import biomesoplenty.block.ThermalCalciteBlock;
import biomesoplenty.block.ThermalCalciteVentBlock;
import biomesoplenty.block.TinyCactusBlock;
import biomesoplenty.block.WallHangingSignBlockBOP;
import biomesoplenty.block.WallSignBlockBOP;
import biomesoplenty.block.WaterlilyBlockBOP;
import biomesoplenty.block.WebbingBlock;
import biomesoplenty.block.WispjellyBlock;
import biomesoplenty.block.trees.BOPTreeGrowers;
import biomesoplenty.init.ModParticles;
import biomesoplenty.worldgen.BOPSurfaceRuleData;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ColorRGBA;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.LeafLitterBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TintedParticleLeavesBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.UntintedParticleLeavesBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import terrablender.api.SurfaceRuleManager;

public class ModBlocks {
    public static void setup(BiConsumer<ResourceLocation, Block> func) {
        ModBlocks.registerBlocks(func);
        ModBlocks.registerSurfaceRules();
    }

    private static void registerSurfaceRules() {
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)"biomesoplenty", (SurfaceRules.RuleSource)BOPSurfaceRuleData.overworld());
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.NETHER, (String)"biomesoplenty", (SurfaceRules.RuleSource)BOPSurfaceRuleData.nether());
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.END, (String)"biomesoplenty", (SurfaceRules.RuleSource)BOPSurfaceRuleData.end());
    }

    private static void registerBlocks(BiConsumer<ResourceLocation, Block> func) {
        BOPBlocks.BLOOD = ModBlocks.register(func, "blood", (BlockBehaviour.Properties p) -> new BloodBlock(BOPFluids.FLOWING_BLOOD, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().replaceable().pushReaction(PushReaction.DESTROY).liquid().noCollission().randomTicks().noLootTable().mapColor(MapColor.CRIMSON_NYLIUM).sound(SoundType.EMPTY).strength(100.0f));
        BOPBlocks.LIQUID_NULL = ModBlocks.register(func, "liquid_null", (BlockBehaviour.Properties p) -> new BloodBlock(BOPFluids.FLOWING_LIQUID_NULL, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().replaceable().pushReaction(PushReaction.DESTROY).liquid().noCollission().randomTicks().noLootTable().sound(SoundType.EMPTY).strength(100.0f));
        BOPBlocks.WHITE_SAND = ModBlocks.register(func, "white_sand", (BlockBehaviour.Properties p) -> new SandBlockBOP(new ColorRGBA(15987172), (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SNARE).mapColor(MapColor.QUARTZ).strength(0.5f).sound(SoundType.SAND));
        BOPBlocks.WHITE_SANDSTONE = ModBlocks.register(func, "white_sandstone", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.QUARTZ).requiresCorrectToolForDrops().strength(0.8f));
        BOPBlocks.WHITE_SANDSTONE_STAIRS = ModBlocks.register(func, "white_sandstone_stairs", (BlockBehaviour.Properties p) -> new StairBlock(BOPBlocks.WHITE_SANDSTONE.defaultBlockState(), p), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.WHITE_SANDSTONE));
        BOPBlocks.WHITE_SANDSTONE_SLAB = ModBlocks.register(func, "white_sandstone_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.WHITE_SANDSTONE));
        BOPBlocks.WHITE_SANDSTONE_WALL = ModBlocks.register(func, "white_sandstone_wall", WallBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.WHITE_SANDSTONE).forceSolidOn());
        BOPBlocks.SMOOTH_WHITE_SANDSTONE = ModBlocks.register(func, "smooth_white_sandstone", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.QUARTZ).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
        BOPBlocks.SMOOTH_WHITE_SANDSTONE_STAIRS = ModBlocks.register(func, "smooth_white_sandstone_stairs", (BlockBehaviour.Properties p) -> new StairBlock(BOPBlocks.WHITE_SANDSTONE.defaultBlockState(), p), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.SMOOTH_WHITE_SANDSTONE));
        BOPBlocks.SMOOTH_WHITE_SANDSTONE_SLAB = ModBlocks.register(func, "smooth_white_sandstone_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.SMOOTH_WHITE_SANDSTONE));
        BOPBlocks.CUT_WHITE_SANDSTONE = ModBlocks.register(func, "cut_white_sandstone", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.QUARTZ).requiresCorrectToolForDrops().strength(0.8f));
        BOPBlocks.CUT_WHITE_SANDSTONE_SLAB = ModBlocks.register(func, "cut_white_sandstone_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.CUT_WHITE_SANDSTONE));
        BOPBlocks.CHISELED_WHITE_SANDSTONE = ModBlocks.register(func, "chiseled_white_sandstone", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.QUARTZ).requiresCorrectToolForDrops().strength(0.8f));
        BOPBlocks.ORANGE_SAND = ModBlocks.register(func, "orange_sand", (BlockBehaviour.Properties p) -> new SandBlockBOP(new ColorRGBA(13408865), (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SNARE).mapColor(MapColor.COLOR_ORANGE).strength(0.5f).sound(SoundType.SAND));
        BOPBlocks.ORANGE_SANDSTONE = ModBlocks.register(func, "orange_sandstone", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.COLOR_ORANGE).requiresCorrectToolForDrops().strength(0.8f));
        BOPBlocks.ORANGE_SANDSTONE_STAIRS = ModBlocks.register(func, "orange_sandstone_stairs", (BlockBehaviour.Properties p) -> new StairBlock(BOPBlocks.ORANGE_SANDSTONE.defaultBlockState(), p), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.ORANGE_SANDSTONE));
        BOPBlocks.ORANGE_SANDSTONE_SLAB = ModBlocks.register(func, "orange_sandstone_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.ORANGE_SANDSTONE));
        BOPBlocks.ORANGE_SANDSTONE_WALL = ModBlocks.register(func, "orange_sandstone_wall", WallBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.ORANGE_SANDSTONE).forceSolidOn());
        BOPBlocks.SMOOTH_ORANGE_SANDSTONE = ModBlocks.register(func, "smooth_orange_sandstone", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.COLOR_ORANGE).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
        BOPBlocks.SMOOTH_ORANGE_SANDSTONE_STAIRS = ModBlocks.register(func, "smooth_orange_sandstone_stairs", (BlockBehaviour.Properties p) -> new StairBlock(BOPBlocks.ORANGE_SANDSTONE.defaultBlockState(), p), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.SMOOTH_ORANGE_SANDSTONE));
        BOPBlocks.SMOOTH_ORANGE_SANDSTONE_SLAB = ModBlocks.register(func, "smooth_orange_sandstone_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.SMOOTH_ORANGE_SANDSTONE));
        BOPBlocks.CUT_ORANGE_SANDSTONE = ModBlocks.register(func, "cut_orange_sandstone", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.COLOR_ORANGE).requiresCorrectToolForDrops().strength(0.8f));
        BOPBlocks.CUT_ORANGE_SANDSTONE_SLAB = ModBlocks.register(func, "cut_orange_sandstone_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.CUT_ORANGE_SANDSTONE));
        BOPBlocks.CHISELED_ORANGE_SANDSTONE = ModBlocks.register(func, "chiseled_orange_sandstone", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.COLOR_ORANGE).requiresCorrectToolForDrops().strength(0.8f));
        BOPBlocks.MOSSY_BLACK_SAND = ModBlocks.register(func, "mossy_black_sand", (BlockBehaviour.Properties p) -> new OvergrownSandBlock(new ColorRGBA(2960431), (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SNARE).mapColor(MapColor.COLOR_GREEN).strength(0.5f).randomTicks().sound(SoundType.MOSS));
        BOPBlocks.BLACK_SAND = ModBlocks.register(func, "black_sand", (BlockBehaviour.Properties p) -> new SandBlockBOP(new ColorRGBA(2960431), (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SNARE).mapColor(MapColor.COLOR_BLACK).strength(0.5f).sound(SoundType.SAND));
        BOPBlocks.BLACK_SANDSTONE = ModBlocks.register(func, "black_sandstone", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.COLOR_BLACK).requiresCorrectToolForDrops().strength(0.8f));
        BOPBlocks.BLACK_SANDSTONE_STAIRS = ModBlocks.register(func, "black_sandstone_stairs", (BlockBehaviour.Properties p) -> new StairBlock(BOPBlocks.BLACK_SANDSTONE.defaultBlockState(), p), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.BLACK_SANDSTONE));
        BOPBlocks.BLACK_SANDSTONE_SLAB = ModBlocks.register(func, "black_sandstone_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.BLACK_SANDSTONE));
        BOPBlocks.BLACK_SANDSTONE_WALL = ModBlocks.register(func, "black_sandstone_wall", WallBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.BLACK_SANDSTONE).forceSolidOn());
        BOPBlocks.SMOOTH_BLACK_SANDSTONE = ModBlocks.register(func, "smooth_black_sandstone", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.COLOR_BLACK).requiresCorrectToolForDrops().strength(2.0f, 6.0f));
        BOPBlocks.SMOOTH_BLACK_SANDSTONE_STAIRS = ModBlocks.register(func, "smooth_black_sandstone_stairs", (BlockBehaviour.Properties p) -> new StairBlock(BOPBlocks.BLACK_SANDSTONE.defaultBlockState(), p), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.SMOOTH_BLACK_SANDSTONE));
        BOPBlocks.SMOOTH_BLACK_SANDSTONE_SLAB = ModBlocks.register(func, "smooth_black_sandstone_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.SMOOTH_BLACK_SANDSTONE));
        BOPBlocks.CUT_BLACK_SANDSTONE = ModBlocks.register(func, "cut_black_sandstone", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.COLOR_BLACK).requiresCorrectToolForDrops().strength(0.8f));
        BOPBlocks.CUT_BLACK_SANDSTONE_SLAB = ModBlocks.register(func, "cut_black_sandstone_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.CUT_BLACK_SANDSTONE));
        BOPBlocks.CHISELED_BLACK_SANDSTONE = ModBlocks.register(func, "chiseled_black_sandstone", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.COLOR_BLACK).requiresCorrectToolForDrops().strength(0.8f));
        MapColor tc1 = MapColor.GOLD;
        MapColor tc2 = MapColor.COLOR_YELLOW;
        MapColor tc3 = MapColor.COLOR_ORANGE;
        MapColor tc4 = MapColor.TERRACOTTA_ORANGE;
        MapColor tc5 = MapColor.TERRACOTTA_RED;
        BOPBlocks.THERMAL_CALCITE = ModBlocks.register(func, "thermal_calcite", ThermalCalciteBlock::new, BlockBehaviour.Properties.of().mapColor(blockState -> (Integer)blockState.getValue((Property)ThermalCalciteBlock.DISTANCE) == 1 ? tc1 : ((Integer)blockState.getValue((Property)ThermalCalciteBlock.DISTANCE) == 2 ? tc2 : ((Integer)blockState.getValue((Property)ThermalCalciteBlock.DISTANCE) == 3 ? tc3 : ((Integer)blockState.getValue((Property)ThermalCalciteBlock.DISTANCE) == 4 ? tc4 : tc5)))).instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.CALCITE).requiresCorrectToolForDrops().strength(0.75f));
        BOPBlocks.THERMAL_CALCITE_VENT = ModBlocks.register(func, "thermal_calcite_vent", ThermalCalciteVentBlock::new, BlockBehaviour.Properties.of().mapColor(blockState -> (Integer)blockState.getValue((Property)ThermalCalciteBlock.DISTANCE) == 1 ? tc1 : ((Integer)blockState.getValue((Property)ThermalCalciteBlock.DISTANCE) == 2 ? tc2 : ((Integer)blockState.getValue((Property)ThermalCalciteBlock.DISTANCE) == 3 ? tc3 : ((Integer)blockState.getValue((Property)ThermalCalciteBlock.DISTANCE) == 4 ? tc4 : tc5)))).instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.CALCITE).requiresCorrectToolForDrops().strength(0.75f));
        BOPBlocks.DRIED_SALT = ModBlocks.register(func, "dried_salt", DriedSaltBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(1.0f).sound(new SoundType(1.0f, 0.5f, SoundEvents.GRAVEL_BREAK, SoundEvents.GRAVEL_STEP, SoundEvents.GRAVEL_PLACE, SoundEvents.GRAVEL_HIT, SoundEvents.GRAVEL_FALL)));
        BOPBlocks.FLESH = ModBlocks.register(func, "flesh", FleshBlock::new, BlockBehaviour.Properties.of().randomTicks().mapColor(MapColor.TERRACOTTA_RED).strength(0.4f).sound(new SoundType(1.0f, 0.5f, SoundEvents.CORAL_BLOCK_BREAK, SoundEvents.CORAL_BLOCK_STEP, SoundEvents.CORAL_BLOCK_PLACE, SoundEvents.CORAL_BLOCK_HIT, SoundEvents.CORAL_BLOCK_FALL)));
        BOPBlocks.POROUS_FLESH = ModBlocks.register(func, "porous_flesh", FleshBlock::new, BlockBehaviour.Properties.of().randomTicks().mapColor(MapColor.TERRACOTTA_RED).strength(0.4f).sound(new SoundType(1.0f, 0.5f, SoundEvents.CORAL_BLOCK_BREAK, SoundEvents.CORAL_BLOCK_STEP, SoundEvents.CORAL_BLOCK_PLACE, SoundEvents.CORAL_BLOCK_HIT, SoundEvents.CORAL_BLOCK_FALL)));
        BOPBlocks.FLESH_TENDONS = ModBlocks.register(func, "flesh_tendons", FleshTendonsBottomBlock::new, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.TERRACOTTA_RED).noCollission().strength(0.2f).sound(new SoundType(1.0f, 0.5f, SoundEvents.CORAL_BLOCK_BREAK, SoundEvents.CORAL_BLOCK_STEP, SoundEvents.CORAL_BLOCK_PLACE, SoundEvents.CORAL_BLOCK_HIT, SoundEvents.CORAL_BLOCK_FALL)));
        BOPBlocks.FLESH_TENDONS_STRAND = ModBlocks.register(func, "flesh_tendons_strand", FleshTendonsBlock::new, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.TERRACOTTA_RED).noCollission().strength(0.2f).sound(new SoundType(1.0f, 0.5f, SoundEvents.CORAL_BLOCK_BREAK, SoundEvents.CORAL_BLOCK_STEP, SoundEvents.CORAL_BLOCK_PLACE, SoundEvents.CORAL_BLOCK_HIT, SoundEvents.CORAL_BLOCK_FALL)));
        BOPBlocks.EYEBULB = ModBlocks.register(func, "eyebulb", EyebulbBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_RED).pushReaction(PushReaction.DESTROY).noCollission().strength(0.2f).sound(new SoundType(1.0f, 0.5f, SoundEvents.CORAL_BLOCK_BREAK, SoundEvents.CORAL_BLOCK_STEP, SoundEvents.CORAL_BLOCK_PLACE, SoundEvents.CORAL_BLOCK_HIT, SoundEvents.CORAL_BLOCK_FALL)).offsetType(BlockBehaviour.OffsetType.NONE));
        BOPBlocks.HAIR = ModBlocks.register(func, "hair", HairBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.RAW_IRON).pushReaction(PushReaction.DESTROY).noCollission().instabreak().sound(SoundType.WOOL).offsetType(BlockBehaviour.OffsetType.XYZ));
        BOPBlocks.PUS_BUBBLE = ModBlocks.register(func, "pus_bubble", PusBubbleBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_PINK).pushReaction(PushReaction.DESTROY).noCollission().instabreak().sound(new SoundType(1.0f, 1.0f, BOPSounds.PUS_BUBBLE_POP, BOPSounds.PUS_BUBBLE_POP, SoundEvents.CORAL_BLOCK_PLACE, BOPSounds.PUS_BUBBLE_POP, BOPSounds.PUS_BUBBLE_POP)));
        BOPBlocks.BRIMSTONE = ModBlocks.register(func, "brimstone", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.COLOR_YELLOW).requiresCorrectToolForDrops().strength(0.5f));
        BOPBlocks.BRIMSTONE_BRICKS = ModBlocks.register(func, "brimstone_bricks", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.COLOR_YELLOW).requiresCorrectToolForDrops().strength(1.0f, 3.0f));
        BOPBlocks.BRIMSTONE_BRICK_STAIRS = ModBlocks.register(func, "brimstone_brick_stairs", (BlockBehaviour.Properties p) -> new StairBlock(BOPBlocks.BRIMSTONE_BRICKS.defaultBlockState(), p), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.BRIMSTONE_BRICKS));
        BOPBlocks.BRIMSTONE_BRICK_SLAB = ModBlocks.register(func, "brimstone_brick_slab", SlabBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.BRIMSTONE_BRICKS));
        BOPBlocks.BRIMSTONE_BRICK_WALL = ModBlocks.register(func, "brimstone_brick_wall", WallBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.BRIMSTONE_BRICKS).forceSolidOn());
        BOPBlocks.CHISELED_BRIMSTONE_BRICKS = ModBlocks.register(func, "chiseled_brimstone_bricks", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.COLOR_YELLOW).requiresCorrectToolForDrops().strength(1.0f, 3.0f));
        BOPBlocks.BRIMSTONE_FUMAROLE = ModBlocks.register(func, "brimstone_fumarole", BrimstoneFumaroleBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.BRIMSTONE));
        BOPBlocks.BRIMSTONE_CLUSTER = ModBlocks.register(func, "brimstone_cluster", BrimstoneClusterBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).pushReaction(PushReaction.DESTROY).strength(0.2f).sound(SoundType.STONE).offsetType(BlockBehaviour.OffsetType.NONE));
        BOPBlocks.BRIMSTONE_BUD = ModBlocks.register(func, "brimstone_bud", BrimstoneBudBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).pushReaction(PushReaction.DESTROY).noCollission().strength(0.2f).sound(SoundType.STONE).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.BLACKSTONE_SPINES = ModBlocks.register(func, "blackstone_spines", BlackstoneDecorationBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).pushReaction(PushReaction.DESTROY).noCollission().strength(0.2f).sound(SoundType.STONE).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.BLACKSTONE_BULB = ModBlocks.register(func, "blackstone_bulb", BlackstoneDecorationBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).pushReaction(PushReaction.DESTROY).noCollission().strength(0.2f).sound(SoundType.STONE).offsetType(BlockBehaviour.OffsetType.XZ).lightLevel(state -> 2).emissiveRendering((state, world, pos) -> true));
        BOPBlocks.ROSE_QUARTZ_BLOCK = ModBlocks.register(func, "rose_quartz_block", AmethystBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.CRIMSON_STEM).strength(1.5f).sound(SoundType.AMETHYST).requiresCorrectToolForDrops().lightLevel(state -> 10));
        BOPBlocks.ROSE_QUARTZ_CLUSTER = ModBlocks.register(func, "rose_quartz_cluster", (BlockBehaviour.Properties p) -> new AmethystClusterBlock(7.0f, 3.0f, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).forceSolidOn().mapColor(MapColor.CRIMSON_STEM).noOcclusion().randomTicks().sound(SoundType.AMETHYST_CLUSTER).strength(1.5f).lightLevel(state -> 8));
        BOPBlocks.LARGE_ROSE_QUARTZ_BUD = ModBlocks.register(func, "large_rose_quartz_bud", (BlockBehaviour.Properties p) -> new AmethystClusterBlock(5.0f, 3.0f, p), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.ROSE_QUARTZ_CLUSTER).pushReaction(PushReaction.DESTROY).forceSolidOn().sound(SoundType.MEDIUM_AMETHYST_BUD).lightLevel(state -> 7));
        BOPBlocks.MEDIUM_ROSE_QUARTZ_BUD = ModBlocks.register(func, "medium_rose_quartz_bud", (BlockBehaviour.Properties p) -> new AmethystClusterBlock(4.0f, 3.0f, p), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.ROSE_QUARTZ_CLUSTER).pushReaction(PushReaction.DESTROY).forceSolidOn().sound(SoundType.LARGE_AMETHYST_BUD).lightLevel(state -> 6));
        BOPBlocks.SMALL_ROSE_QUARTZ_BUD = ModBlocks.register(func, "small_rose_quartz_bud", (BlockBehaviour.Properties p) -> new AmethystClusterBlock(3.0f, 4.0f, p), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.ROSE_QUARTZ_CLUSTER).pushReaction(PushReaction.DESTROY).forceSolidOn().sound(SoundType.SMALL_AMETHYST_BUD).lightLevel(state -> 5));
        BOPBlocks.BARNACLES = ModBlocks.register(func, "barnacles", BarnaclesBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.CLAY).pushReaction(PushReaction.DESTROY).replaceable().noCollission().sound(SoundType.CORAL_BLOCK));
        BOPBlocks.WISPJELLY = ModBlocks.register(func, "wispjelly", WispjellyBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).mapColor(MapColor.GLOW_LICHEN).noOcclusion().noCollission().sound(SoundType.CORAL_BLOCK).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never).strength(0.2f).lightLevel(state -> 1).emissiveRendering((state, world, pos) -> true));
        BOPBlocks.ALGAL_END_STONE = ModBlocks.register(func, "algal_end_stone", AlgalEndStoneBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.TERRACOTTA_YELLOW).randomTicks().requiresCorrectToolForDrops().strength(3.0f, 9.0f));
        BOPBlocks.UNMAPPED_END_STONE = ModBlocks.register(func, "unmapped_end_stone", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.SAND).requiresCorrectToolForDrops().strength(3.0f, 9.0f));
        BOPBlocks.NULL_END_STONE = ModBlocks.register(func, "null_end_stone", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.SAND).requiresCorrectToolForDrops().strength(1.5f, 4.5f));
        BOPBlocks.NULL_BLOCK = ModBlocks.register(func, "null_block", NullBlock::new, BlockBehaviour.Properties.of());
        BOPBlocks.NULL_LEAVES = ModBlocks.register(func, "null_leaves", NullLeavesBlock::new, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).strength(0.2f).randomTicks().noOcclusion().isValidSpawn(ModBlocks::ocelotOrParrot).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never).isRedstoneConductor(ModBlocks::never));
        BOPBlocks.NULL_PLANT = ModBlocks.register(func, "null_plant", NullPlantBlock::new, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).replaceable().noCollission().instabreak().offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.ANOMALY = ModBlocks.register(func, "anomaly", AnomalyBlock::new, BlockBehaviour.Properties.of().lightLevel(state -> 5));
        BOPBlocks.TOADSTOOL = ModBlocks.register(func, "toadstool", MushroomBlockBOP::new, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.COLOR_ORANGE).noCollission().instabreak().sound(SoundType.GRASS));
        BOPBlocks.TOADSTOOL_BLOCK = ModBlocks.register(func, "toadstool_block", HugeMushroomBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.COLOR_ORANGE).strength(0.2f).sound(SoundType.WOOD));
        BOPBlocks.GLOWSHROOM = ModBlocks.register(func, "glowshroom", MushroomBlockBOP::new, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.DIAMOND).noCollission().instabreak().sound(SoundType.GRASS).lightLevel(state -> 3));
        BOPBlocks.GLOWSHROOM_BLOCK = ModBlocks.register(func, "glowshroom_block", HugeMushroomBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.DIAMOND).strength(0.2f).sound(SoundType.WOOD).lightLevel(state -> 10).emissiveRendering((state, world, pos) -> true));
        BOPBlocks.GLOWING_MOSS_BLOCK = ModBlocks.register(func, "glowing_moss_block", GlowingMossBlock::new, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.DIAMOND).strength(0.1f).sound(SoundType.MOSS).lightLevel(state -> 3));
        BOPBlocks.GLOWING_MOSS_CARPET = ModBlocks.register(func, "glowing_moss_carpet", CarpetBlock::new, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.DIAMOND).strength(0.1f).sound(SoundType.MOSS_CARPET).lightLevel(state -> 3));
        BOPBlocks.GLOWWORM_SILK = ModBlocks.register(func, "glowworm_silk", GlowwormSilkBottomBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.DIAMOND).pushReaction(PushReaction.DESTROY).replaceable().ignitedByLava().noCollission().instabreak().sound(SoundType.WOOL).lightLevel(state -> 2).emissiveRendering((state, world, pos) -> true));
        BOPBlocks.GLOWWORM_SILK_STRAND = ModBlocks.register(func, "glowworm_silk_strand", GlowwormSilkBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.DIAMOND).pushReaction(PushReaction.DESTROY).replaceable().ignitedByLava().noCollission().instabreak().sound(SoundType.WOOL).lightLevel(state -> 2).emissiveRendering((state, world, pos) -> true));
        BOPBlocks.SPIDER_EGG = ModBlocks.register(func, "spider_egg", SpiderEggBlock::new, BlockBehaviour.Properties.of().strength(0.1f).mapColor(MapColor.WOOL).pushReaction(PushReaction.DESTROY).sound(SoundType.COBWEB).lightLevel(state -> 5));
        BOPBlocks.HANGING_COBWEB = ModBlocks.register(func, "hanging_cobweb", HangingCobwebBottomBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOL).pushReaction(PushReaction.DESTROY).replaceable().ignitedByLava().noCollission().instabreak().sound(SoundType.COBWEB));
        BOPBlocks.HANGING_COBWEB_STRAND = ModBlocks.register(func, "hanging_cobweb_strand", HangingCobwebBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOL).pushReaction(PushReaction.DESTROY).replaceable().ignitedByLava().noCollission().instabreak().sound(SoundType.COBWEB));
        BOPBlocks.STRINGY_COBWEB = ModBlocks.register(func, "stringy_cobweb", StringyCobwebBlock::new, BlockBehaviour.Properties.of().noLootTable().mapColor(MapColor.WOOL).pushReaction(PushReaction.DESTROY).replaceable().ignitedByLava().noCollission().instabreak().sound(SoundType.COBWEB));
        BOPBlocks.WEBBING = ModBlocks.register(func, "webbing", WebbingBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.WOOL).pushReaction(PushReaction.DESTROY).replaceable().ignitedByLava().noCollission().instabreak().sound(SoundType.COBWEB));
        BOPBlocks.ORIGIN_GRASS_BLOCK = ModBlocks.register(func, "origin_grass_block", OriginGrassBlock::new, BlockBehaviour.Properties.of().randomTicks().mapColor(MapColor.GRASS).strength(0.6f).randomTicks().sound(SoundType.GRASS));
        BOPBlocks.ORIGIN_SAPLING = ModBlocks.register(func, "origin_sapling", (BlockBehaviour.Properties p) -> new SaplingBlockBOP(BOPTreeGrowers.ORIGIN, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).noCollission().randomTicks().instabreak().sound(SoundType.GRASS));
        BOPBlocks.ORIGIN_LEAVES = ModBlocks.register(func, "origin_leaves", (BlockBehaviour.Properties p) -> new TintedParticleLeavesBlock(0.0f, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.EMERALD).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(ModBlocks::ocelotOrParrot).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never).ignitedByLava().isRedstoneConductor(ModBlocks::never));
        BOPBlocks.FLOWERING_OAK_SAPLING = ModBlocks.register(func, "flowering_oak_sapling", (BlockBehaviour.Properties p) -> new SaplingBlockBOP(BOPTreeGrowers.FLOWERING_OAK, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).noCollission().randomTicks().instabreak().sound(SoundType.GRASS));
        BOPBlocks.FLOWERING_OAK_LEAVES = ModBlocks.register(func, "flowering_oak_leaves", (BlockBehaviour.Properties p) -> new TintedParticleLeavesBlock(0.01f, p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(ModBlocks::ocelotOrParrot).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never).ignitedByLava().isRedstoneConductor(ModBlocks::never));
        BOPBlocks.CYPRESS_SAPLING = ModBlocks.register(func, "cypress_sapling", (BlockBehaviour.Properties p) -> new SaplingBlockBOP(BOPTreeGrowers.CYPRESS, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).noCollission().randomTicks().instabreak().sound(SoundType.GRASS));
        BOPBlocks.CYPRESS_LEAVES = ModBlocks.register(func, "cypress_leaves", (BlockBehaviour.Properties p) -> new UntintedParticleLeavesBlock(0.005f, (ParticleOptions)ModParticles.CYPRESS_LEAVES, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.PLANT).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(ModBlocks::ocelotOrParrot).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never).ignitedByLava().isRedstoneConductor(ModBlocks::never));
        BOPBlocks.SNOWBLOSSOM_SAPLING = ModBlocks.register(func, "snowblossom_sapling", (BlockBehaviour.Properties p) -> new SaplingBlockBOP(BOPTreeGrowers.SNOWBLOSSOM, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).pushReaction(PushReaction.DESTROY).noCollission().randomTicks().instabreak().sound(SoundType.CHERRY_SAPLING));
        BOPBlocks.SNOWBLOSSOM_LEAVES = ModBlocks.register(func, "snowblossom_leaves", (BlockBehaviour.Properties p) -> new UntintedParticleLeavesBlock(0.075f, (ParticleOptions)ModParticles.SNOWBLOSSOM_LEAVES, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.SNOW).strength(0.2f).randomTicks().sound(SoundType.CHERRY_LEAVES).noOcclusion().isValidSpawn(ModBlocks::ocelotOrParrot).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never).ignitedByLava().isRedstoneConductor(ModBlocks::never));
        BOPBlocks.RAINBOW_BIRCH_SAPLING = ModBlocks.register(func, "rainbow_birch_sapling", (BlockBehaviour.Properties p) -> new SaplingBlockBOP(BOPTreeGrowers.RAINBOW_BIRCH, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).noCollission().randomTicks().instabreak().sound(SoundType.GRASS).lightLevel(state -> 5));
        BOPBlocks.RAINBOW_BIRCH_LEAVES = ModBlocks.register(func, "rainbow_birch_leaves", (BlockBehaviour.Properties p) -> new TintedParticleLeavesBlock(0.05f, p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(ModBlocks::ocelotOrParrot).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never).ignitedByLava().isRedstoneConductor(ModBlocks::never).lightLevel(state -> 8));
        BOPBlocks.FIR_SAPLING = ModBlocks.register(func, "fir_sapling", (BlockBehaviour.Properties p) -> new SaplingBlockBOP(BOPTreeGrowers.FIR, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).noCollission().randomTicks().instabreak().sound(SoundType.GRASS));
        BOPBlocks.FIR_LEAVES = ModBlocks.register(func, "fir_leaves", (BlockBehaviour.Properties p) -> new UntintedParticleLeavesBlock(0.001f, (ParticleOptions)ModParticles.FIR_LEAVES, p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(ModBlocks::ocelotOrParrot).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never).ignitedByLava().isRedstoneConductor(ModBlocks::never));
        BOPBlocks.FIR_LOG = ModBlocks.register(func, "fir_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.TERRACOTTA_WHITE, MapColor.TERRACOTTA_LIGHT_GRAY, SoundType.WOOD));
        BOPBlocks.FIR_WOOD = ModBlocks.register(func, "fir_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_LIGHT_GRAY).strength(2.0f).sound(SoundType.WOOD));
        BOPBlocks.STRIPPED_FIR_LOG = ModBlocks.register(func, "stripped_fir_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.TERRACOTTA_WHITE, MapColor.TERRACOTTA_WHITE, SoundType.WOOD));
        BOPBlocks.STRIPPED_FIR_WOOD = ModBlocks.register(func, "stripped_fir_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_WHITE).strength(2.0f).sound(SoundType.WOOD));
        BOPBlocks.FIR_PLANKS = ModBlocks.register(func, "fir_planks", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_WHITE).strength(2.0f, 3.0f).sound(SoundType.WOOD));
        BOPBlocks.FIR_STAIRS = ModBlocks.register(func, "fir_stairs", (BlockBehaviour.Properties p) -> new StairBlock(BOPBlocks.FIR_PLANKS.defaultBlockState(), p), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.FIR_PLANKS));
        BOPBlocks.FIR_SLAB = ModBlocks.register(func, "fir_slab", SlabBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_WHITE).strength(2.0f, 3.0f).sound(SoundType.WOOD));
        BOPBlocks.FIR_FENCE = ModBlocks.register(func, "fir_fence", FenceBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.FIR_PLANKS.defaultMapColor()).strength(2.0f, 3.0f).sound(SoundType.WOOD));
        BOPBlocks.FIR_FENCE_GATE = ModBlocks.register(func, "fir_fence_gate", (BlockBehaviour.Properties p) -> new FenceGateBlock(BOPWoodTypes.FIR, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.FIR_PLANKS.defaultMapColor()).strength(2.0f, 3.0f));
        BOPBlocks.FIR_DOOR = ModBlocks.register(func, "fir_door", (BlockBehaviour.Properties p) -> new DoorBlock(BOPBlockSetTypes.FIR, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(BOPBlocks.FIR_PLANKS.defaultMapColor()).strength(3.0f).noOcclusion());
        BOPBlocks.FIR_TRAPDOOR = ModBlocks.register(func, "fir_trapdoor", (BlockBehaviour.Properties p) -> new TrapDoorBlock(BOPBlockSetTypes.FIR, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_WHITE).strength(3.0f).noOcclusion());
        BOPBlocks.FIR_PRESSURE_PLATE = ModBlocks.register(func, "fir_pressure_plate", (BlockBehaviour.Properties p) -> new PressurePlateBlock(BOPBlockSetTypes.FIR, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.FIR_PLANKS.defaultMapColor()).noCollission().strength(0.5f));
        BOPBlocks.FIR_BUTTON = ModBlocks.register(func, "fir_button", (BlockBehaviour.Properties p) -> new ButtonBlock(BOPBlockSetTypes.FIR, 30, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).noCollission().strength(0.5f));
        BOPBlocks.FIR_SIGN = ModBlocks.register(func, "fir_sign", (BlockBehaviour.Properties p) -> new StandingSignBlockBOP(BOPWoodTypes.FIR, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.FIR_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.FIR_WALL_SIGN = ModBlocks.register(func, "fir_wall_sign", (BlockBehaviour.Properties p) -> new WallSignBlockBOP(BOPWoodTypes.FIR, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.FIR_SIGN, true).mapColor(BOPBlocks.FIR_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.FIR_HANGING_SIGN = ModBlocks.register(func, "fir_hanging_sign", (BlockBehaviour.Properties p) -> new CeilingHangingSignBlockBOP(BOPWoodTypes.FIR, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.FIR_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.FIR_WALL_HANGING_SIGN = ModBlocks.register(func, "fir_wall_hanging_sign", (BlockBehaviour.Properties p) -> new WallHangingSignBlockBOP(BOPWoodTypes.FIR, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.FIR_HANGING_SIGN, true).mapColor(BOPBlocks.FIR_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.PINE_SAPLING = ModBlocks.register(func, "pine_sapling", (BlockBehaviour.Properties p) -> new SaplingBlockBOP(BOPTreeGrowers.PINE, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).noCollission().randomTicks().instabreak().sound(SoundType.GRASS));
        BOPBlocks.PINE_LEAVES = ModBlocks.register(func, "pine_leaves", (BlockBehaviour.Properties p) -> new TintedParticleLeavesBlock(0.0025f, p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(ModBlocks::ocelotOrParrot).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never).ignitedByLava().isRedstoneConductor(ModBlocks::never));
        BOPBlocks.PINE_LOG = ModBlocks.register(func, "pine_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.TERRACOTTA_LIGHT_GREEN, MapColor.DIRT, SoundType.WOOD));
        BOPBlocks.PINE_WOOD = ModBlocks.register(func, "pine_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.DIRT).strength(2.0f).sound(SoundType.WOOD));
        BOPBlocks.STRIPPED_PINE_LOG = ModBlocks.register(func, "stripped_pine_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.TERRACOTTA_LIGHT_GREEN, MapColor.TERRACOTTA_LIGHT_GREEN, SoundType.WOOD));
        BOPBlocks.STRIPPED_PINE_WOOD = ModBlocks.register(func, "stripped_pine_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_LIGHT_GREEN).strength(2.0f).sound(SoundType.WOOD));
        BOPBlocks.PINE_PLANKS = ModBlocks.register(func, "pine_planks", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_LIGHT_GREEN).strength(2.0f, 3.0f).sound(SoundType.WOOD));
        BOPBlocks.PINE_STAIRS = ModBlocks.register(func, "pine_stairs", (BlockBehaviour.Properties p) -> new StairBlock(BOPBlocks.PINE_PLANKS.defaultBlockState(), p), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.PINE_PLANKS));
        BOPBlocks.PINE_SLAB = ModBlocks.register(func, "pine_slab", SlabBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_LIGHT_GREEN).strength(2.0f, 3.0f).sound(SoundType.WOOD));
        BOPBlocks.PINE_FENCE = ModBlocks.register(func, "pine_fence", FenceBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.PINE_PLANKS.defaultMapColor()).strength(2.0f, 3.0f).sound(SoundType.WOOD));
        BOPBlocks.PINE_FENCE_GATE = ModBlocks.register(func, "pine_fence_gate", (BlockBehaviour.Properties p) -> new FenceGateBlock(BOPWoodTypes.PINE, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.PINE_PLANKS.defaultMapColor()).strength(2.0f, 3.0f));
        BOPBlocks.PINE_DOOR = ModBlocks.register(func, "pine_door", (BlockBehaviour.Properties p) -> new DoorBlock(BOPBlockSetTypes.PINE, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(BOPBlocks.PINE_PLANKS.defaultMapColor()).strength(3.0f).noOcclusion());
        BOPBlocks.PINE_TRAPDOOR = ModBlocks.register(func, "pine_trapdoor", (BlockBehaviour.Properties p) -> new TrapDoorBlock(BOPBlockSetTypes.PINE, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_LIGHT_GREEN).strength(3.0f).noOcclusion());
        BOPBlocks.PINE_PRESSURE_PLATE = ModBlocks.register(func, "pine_pressure_plate", (BlockBehaviour.Properties p) -> new PressurePlateBlock(BOPBlockSetTypes.PINE, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.PINE_PLANKS.defaultMapColor()).noCollission().strength(0.5f));
        BOPBlocks.PINE_BUTTON = ModBlocks.register(func, "pine_button", (BlockBehaviour.Properties p) -> new ButtonBlock(BOPBlockSetTypes.PINE, 30, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).noCollission().strength(0.5f));
        BOPBlocks.PINE_SIGN = ModBlocks.register(func, "pine_sign", (BlockBehaviour.Properties p) -> new StandingSignBlockBOP(BOPWoodTypes.PINE, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.PINE_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.PINE_WALL_SIGN = ModBlocks.register(func, "pine_wall_sign", (BlockBehaviour.Properties p) -> new WallSignBlockBOP(BOPWoodTypes.PINE, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.PINE_SIGN, true).mapColor(BOPBlocks.PINE_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.PINE_HANGING_SIGN = ModBlocks.register(func, "pine_hanging_sign", (BlockBehaviour.Properties p) -> new CeilingHangingSignBlockBOP(BOPWoodTypes.PINE, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.PINE_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.PINE_WALL_HANGING_SIGN = ModBlocks.register(func, "pine_wall_hanging_sign", (BlockBehaviour.Properties p) -> new WallHangingSignBlockBOP(BOPWoodTypes.PINE, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.PINE_HANGING_SIGN, true).mapColor(BOPBlocks.PINE_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.RED_MAPLE_SAPLING = ModBlocks.register(func, "red_maple_sapling", (BlockBehaviour.Properties p) -> new SaplingBlockBOP(BOPTreeGrowers.RED_MAPLE, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).pushReaction(PushReaction.DESTROY).noCollission().randomTicks().instabreak().sound(SoundType.CHERRY_SAPLING));
        BOPBlocks.RED_MAPLE_LEAF_LITTER = ModBlocks.register(func, "red_maple_leaf_litter", LeafLitterBlock::new, BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).mapColor(MapColor.COLOR_RED).replaceable().noCollission().sound(SoundType.LEAF_LITTER));
        BOPBlocks.RED_MAPLE_LEAVES = ModBlocks.register(func, "red_maple_leaves", (BlockBehaviour.Properties p) -> new UntintedParticleLeavesBlock(0.005f, (ParticleOptions)ModParticles.RED_MAPLE_LEAVES, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.COLOR_RED).strength(0.2f).randomTicks().sound(SoundType.CHERRY_LEAVES).noOcclusion().isValidSpawn(ModBlocks::ocelotOrParrot).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never).ignitedByLava().isRedstoneConductor(ModBlocks::never));
        BOPBlocks.ORANGE_MAPLE_SAPLING = ModBlocks.register(func, "orange_maple_sapling", (BlockBehaviour.Properties p) -> new SaplingBlockBOP(BOPTreeGrowers.ORANGE_MAPLE, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_ORANGE).pushReaction(PushReaction.DESTROY).noCollission().randomTicks().instabreak().sound(SoundType.CHERRY_SAPLING));
        BOPBlocks.ORANGE_MAPLE_LEAF_LITTER = ModBlocks.register(func, "orange_maple_leaf_litter", LeafLitterBlock::new, BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).mapColor(MapColor.TERRACOTTA_ORANGE).replaceable().noCollission().sound(SoundType.LEAF_LITTER));
        BOPBlocks.ORANGE_MAPLE_LEAVES = ModBlocks.register(func, "orange_maple_leaves", (BlockBehaviour.Properties p) -> new UntintedParticleLeavesBlock(0.01f, (ParticleOptions)ModParticles.ORANGE_MAPLE_LEAVES, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.TERRACOTTA_ORANGE).strength(0.2f).randomTicks().sound(SoundType.CHERRY_LEAVES).noOcclusion().isValidSpawn(ModBlocks::ocelotOrParrot).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never).ignitedByLava().isRedstoneConductor(ModBlocks::never));
        BOPBlocks.YELLOW_MAPLE_SAPLING = ModBlocks.register(func, "yellow_maple_sapling", (BlockBehaviour.Properties p) -> new SaplingBlockBOP(BOPTreeGrowers.YELLOW_MAPLE, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_YELLOW).pushReaction(PushReaction.DESTROY).noCollission().randomTicks().instabreak().sound(SoundType.CHERRY_SAPLING));
        BOPBlocks.YELLOW_MAPLE_LEAF_LITTER = ModBlocks.register(func, "yellow_maple_leaf_litter", LeafLitterBlock::new, BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).mapColor(MapColor.TERRACOTTA_YELLOW).replaceable().noCollission().sound(SoundType.LEAF_LITTER));
        BOPBlocks.YELLOW_MAPLE_LEAVES = ModBlocks.register(func, "yellow_maple_leaves", (BlockBehaviour.Properties p) -> new UntintedParticleLeavesBlock(0.05f, (ParticleOptions)ModParticles.YELLOW_MAPLE_LEAVES, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.TERRACOTTA_YELLOW).strength(0.2f).randomTicks().sound(SoundType.CHERRY_LEAVES).noOcclusion().isValidSpawn(ModBlocks::ocelotOrParrot).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never).ignitedByLava().isRedstoneConductor(ModBlocks::never));
        BOPBlocks.MAPLE_LOG = ModBlocks.register(func, "maple_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.DIRT, MapColor.TERRACOTTA_BROWN, SoundType.CHERRY_WOOD));
        BOPBlocks.MAPLE_WOOD = ModBlocks.register(func, "maple_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_BROWN).strength(2.0f).sound(SoundType.CHERRY_WOOD));
        BOPBlocks.STRIPPED_MAPLE_LOG = ModBlocks.register(func, "stripped_maple_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.DIRT, MapColor.DIRT, SoundType.CHERRY_WOOD));
        BOPBlocks.STRIPPED_MAPLE_WOOD = ModBlocks.register(func, "stripped_maple_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.DIRT).strength(2.0f).sound(SoundType.CHERRY_WOOD));
        BOPBlocks.MAPLE_PLANKS = ModBlocks.register(func, "maple_planks", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.DIRT).strength(2.0f, 3.0f).sound(SoundType.CHERRY_WOOD));
        BOPBlocks.MAPLE_STAIRS = ModBlocks.register(func, "maple_stairs", (BlockBehaviour.Properties p) -> new StairBlock(BOPBlocks.MAPLE_PLANKS.defaultBlockState(), p), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.MAPLE_PLANKS));
        BOPBlocks.MAPLE_SLAB = ModBlocks.register(func, "maple_slab", SlabBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.DIRT).strength(2.0f, 3.0f).sound(SoundType.CHERRY_WOOD));
        BOPBlocks.MAPLE_FENCE = ModBlocks.register(func, "maple_fence", FenceBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.MAPLE_PLANKS.defaultMapColor()).strength(2.0f, 3.0f).sound(SoundType.CHERRY_WOOD));
        BOPBlocks.MAPLE_FENCE_GATE = ModBlocks.register(func, "maple_fence_gate", (BlockBehaviour.Properties p) -> new FenceGateBlock(BOPWoodTypes.MAPLE, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.MAPLE_PLANKS.defaultMapColor()).strength(2.0f, 3.0f));
        BOPBlocks.MAPLE_DOOR = ModBlocks.register(func, "maple_door", (BlockBehaviour.Properties p) -> new DoorBlock(BOPBlockSetTypes.MAPLE, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(BOPBlocks.MAPLE_PLANKS.defaultMapColor()).strength(3.0f).noOcclusion());
        BOPBlocks.MAPLE_TRAPDOOR = ModBlocks.register(func, "maple_trapdoor", (BlockBehaviour.Properties p) -> new TrapDoorBlock(BOPBlockSetTypes.MAPLE, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.DIRT).strength(3.0f).noOcclusion());
        BOPBlocks.MAPLE_PRESSURE_PLATE = ModBlocks.register(func, "maple_pressure_plate", (BlockBehaviour.Properties p) -> new PressurePlateBlock(BOPBlockSetTypes.MAPLE, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.MAPLE_PLANKS.defaultMapColor()).noCollission().strength(0.5f));
        BOPBlocks.MAPLE_BUTTON = ModBlocks.register(func, "maple_button", (BlockBehaviour.Properties p) -> new ButtonBlock(BOPBlockSetTypes.MAPLE, 30, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).noCollission().strength(0.5f));
        BOPBlocks.MAPLE_SIGN = ModBlocks.register(func, "maple_sign", (BlockBehaviour.Properties p) -> new StandingSignBlockBOP(BOPWoodTypes.MAPLE, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.MAPLE_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.MAPLE_WALL_SIGN = ModBlocks.register(func, "maple_wall_sign", (BlockBehaviour.Properties p) -> new WallSignBlockBOP(BOPWoodTypes.MAPLE, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.MAPLE_SIGN, true).mapColor(BOPBlocks.MAPLE_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.MAPLE_HANGING_SIGN = ModBlocks.register(func, "maple_hanging_sign", (BlockBehaviour.Properties p) -> new CeilingHangingSignBlockBOP(BOPWoodTypes.MAPLE, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.MAPLE_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.MAPLE_WALL_HANGING_SIGN = ModBlocks.register(func, "maple_wall_hanging_sign", (BlockBehaviour.Properties p) -> new WallHangingSignBlockBOP(BOPWoodTypes.MAPLE, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.MAPLE_HANGING_SIGN, true).mapColor(BOPBlocks.MAPLE_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.REDWOOD_SAPLING = ModBlocks.register(func, "redwood_sapling", (BlockBehaviour.Properties p) -> new SaplingBlockBOP(BOPTreeGrowers.REDWOOD, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).noCollission().randomTicks().instabreak().sound(SoundType.GRASS));
        BOPBlocks.REDWOOD_LEAVES = ModBlocks.register(func, "redwood_leaves", (BlockBehaviour.Properties p) -> new UntintedParticleLeavesBlock(0.001f, (ParticleOptions)ModParticles.REDWOOD_LEAVES, p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(ModBlocks::ocelotOrParrot).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never).ignitedByLava().isRedstoneConductor(ModBlocks::never));
        BOPBlocks.REDWOOD_LOG = ModBlocks.register(func, "redwood_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.CRIMSON_NYLIUM, MapColor.TERRACOTTA_ORANGE, SoundType.WOOD));
        BOPBlocks.REDWOOD_WOOD = ModBlocks.register(func, "redwood_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_ORANGE).strength(2.0f).sound(SoundType.WOOD));
        BOPBlocks.STRIPPED_REDWOOD_LOG = ModBlocks.register(func, "stripped_redwood_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.CRIMSON_NYLIUM, MapColor.CRIMSON_NYLIUM, SoundType.WOOD));
        BOPBlocks.STRIPPED_REDWOOD_WOOD = ModBlocks.register(func, "stripped_redwood_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.CRIMSON_NYLIUM).strength(2.0f).sound(SoundType.WOOD));
        BOPBlocks.REDWOOD_PLANKS = ModBlocks.register(func, "redwood_planks", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.CRIMSON_NYLIUM).strength(2.0f, 3.0f).sound(SoundType.WOOD));
        BOPBlocks.REDWOOD_STAIRS = ModBlocks.register(func, "redwood_stairs", (BlockBehaviour.Properties p) -> new StairBlock(BOPBlocks.REDWOOD_PLANKS.defaultBlockState(), p), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.REDWOOD_PLANKS));
        BOPBlocks.REDWOOD_SLAB = ModBlocks.register(func, "redwood_slab", SlabBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.CRIMSON_NYLIUM).strength(2.0f, 3.0f).sound(SoundType.WOOD));
        BOPBlocks.REDWOOD_FENCE = ModBlocks.register(func, "redwood_fence", FenceBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.REDWOOD_PLANKS.defaultMapColor()).strength(2.0f, 3.0f).sound(SoundType.WOOD));
        BOPBlocks.REDWOOD_FENCE_GATE = ModBlocks.register(func, "redwood_fence_gate", (BlockBehaviour.Properties p) -> new FenceGateBlock(BOPWoodTypes.REDWOOD, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.REDWOOD_PLANKS.defaultMapColor()).strength(2.0f, 3.0f));
        BOPBlocks.REDWOOD_DOOR = ModBlocks.register(func, "redwood_door", (BlockBehaviour.Properties p) -> new DoorBlock(BOPBlockSetTypes.REDWOOD, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(BOPBlocks.REDWOOD_PLANKS.defaultMapColor()).strength(3.0f).noOcclusion());
        BOPBlocks.REDWOOD_TRAPDOOR = ModBlocks.register(func, "redwood_trapdoor", (BlockBehaviour.Properties p) -> new TrapDoorBlock(BOPBlockSetTypes.REDWOOD, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.CRIMSON_NYLIUM).strength(3.0f).noOcclusion());
        BOPBlocks.REDWOOD_PRESSURE_PLATE = ModBlocks.register(func, "redwood_pressure_plate", (BlockBehaviour.Properties p) -> new PressurePlateBlock(BOPBlockSetTypes.REDWOOD, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.REDWOOD_PLANKS.defaultMapColor()).noCollission().strength(0.5f));
        BOPBlocks.REDWOOD_BUTTON = ModBlocks.register(func, "redwood_button", (BlockBehaviour.Properties p) -> new ButtonBlock(BOPBlockSetTypes.REDWOOD, 30, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).noCollission().strength(0.5f));
        BOPBlocks.REDWOOD_SIGN = ModBlocks.register(func, "redwood_sign", (BlockBehaviour.Properties p) -> new StandingSignBlockBOP(BOPWoodTypes.REDWOOD, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.REDWOOD_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.REDWOOD_WALL_SIGN = ModBlocks.register(func, "redwood_wall_sign", (BlockBehaviour.Properties p) -> new WallSignBlockBOP(BOPWoodTypes.REDWOOD, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.REDWOOD_SIGN, true).mapColor(BOPBlocks.REDWOOD_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.REDWOOD_HANGING_SIGN = ModBlocks.register(func, "redwood_hanging_sign", (BlockBehaviour.Properties p) -> new CeilingHangingSignBlockBOP(BOPWoodTypes.REDWOOD, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.REDWOOD_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.REDWOOD_WALL_HANGING_SIGN = ModBlocks.register(func, "redwood_wall_hanging_sign", (BlockBehaviour.Properties p) -> new WallHangingSignBlockBOP(BOPWoodTypes.REDWOOD, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.REDWOOD_HANGING_SIGN, true).mapColor(BOPBlocks.REDWOOD_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.MAHOGANY_SAPLING = ModBlocks.register(func, "mahogany_sapling", (BlockBehaviour.Properties p) -> new SaplingBlockBOP(BOPTreeGrowers.MAHOGANY, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).noCollission().randomTicks().instabreak().sound(SoundType.GRASS));
        BOPBlocks.MAHOGANY_LEAVES = ModBlocks.register(func, "mahogany_leaves", (BlockBehaviour.Properties p) -> new TintedParticleLeavesBlock(0.01f, p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(ModBlocks::ocelotOrParrot).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never).ignitedByLava().isRedstoneConductor(ModBlocks::never));
        BOPBlocks.MAHOGANY_LOG = ModBlocks.register(func, "mahogany_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.TERRACOTTA_MAGENTA, MapColor.DIRT, SoundType.WOOD));
        BOPBlocks.MAHOGANY_WOOD = ModBlocks.register(func, "mahogany_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.DIRT).strength(2.0f).sound(SoundType.WOOD));
        BOPBlocks.STRIPPED_MAHOGANY_LOG = ModBlocks.register(func, "stripped_mahogany_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.TERRACOTTA_MAGENTA, MapColor.TERRACOTTA_MAGENTA, SoundType.WOOD));
        BOPBlocks.STRIPPED_MAHOGANY_WOOD = ModBlocks.register(func, "stripped_mahogany_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_MAGENTA).strength(2.0f).sound(SoundType.WOOD));
        BOPBlocks.MAHOGANY_PLANKS = ModBlocks.register(func, "mahogany_planks", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_MAGENTA).strength(2.0f, 3.0f).sound(SoundType.WOOD));
        BOPBlocks.MAHOGANY_STAIRS = ModBlocks.register(func, "mahogany_stairs", (BlockBehaviour.Properties p) -> new StairBlock(BOPBlocks.MAHOGANY_PLANKS.defaultBlockState(), p), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.MAHOGANY_PLANKS));
        BOPBlocks.MAHOGANY_SLAB = ModBlocks.register(func, "mahogany_slab", SlabBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_MAGENTA).strength(2.0f, 3.0f).sound(SoundType.WOOD));
        BOPBlocks.MAHOGANY_FENCE = ModBlocks.register(func, "mahogany_fence", FenceBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.MAHOGANY_PLANKS.defaultMapColor()).strength(2.0f, 3.0f).sound(SoundType.WOOD));
        BOPBlocks.MAHOGANY_FENCE_GATE = ModBlocks.register(func, "mahogany_fence_gate", (BlockBehaviour.Properties p) -> new FenceGateBlock(BOPWoodTypes.MAHOGANY, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.MAHOGANY_PLANKS.defaultMapColor()).strength(2.0f, 3.0f));
        BOPBlocks.MAHOGANY_DOOR = ModBlocks.register(func, "mahogany_door", (BlockBehaviour.Properties p) -> new DoorBlock(BOPBlockSetTypes.MAHOGANY, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(BOPBlocks.MAHOGANY_PLANKS.defaultMapColor()).strength(3.0f).noOcclusion());
        BOPBlocks.MAHOGANY_TRAPDOOR = ModBlocks.register(func, "mahogany_trapdoor", (BlockBehaviour.Properties p) -> new TrapDoorBlock(BOPBlockSetTypes.MAHOGANY, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_MAGENTA).strength(3.0f).noOcclusion());
        BOPBlocks.MAHOGANY_PRESSURE_PLATE = ModBlocks.register(func, "mahogany_pressure_plate", (BlockBehaviour.Properties p) -> new PressurePlateBlock(BOPBlockSetTypes.MAHOGANY, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.MAHOGANY_PLANKS.defaultMapColor()).noCollission().strength(0.5f));
        BOPBlocks.MAHOGANY_BUTTON = ModBlocks.register(func, "mahogany_button", (BlockBehaviour.Properties p) -> new ButtonBlock(BOPBlockSetTypes.MAHOGANY, 30, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).noCollission().strength(0.5f));
        BOPBlocks.MAHOGANY_SIGN = ModBlocks.register(func, "mahogany_sign", (BlockBehaviour.Properties p) -> new StandingSignBlockBOP(BOPWoodTypes.MAHOGANY, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.MAHOGANY_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.MAHOGANY_WALL_SIGN = ModBlocks.register(func, "mahogany_wall_sign", (BlockBehaviour.Properties p) -> new WallSignBlockBOP(BOPWoodTypes.MAHOGANY, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.MAHOGANY_SIGN, true).mapColor(BOPBlocks.MAHOGANY_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.MAHOGANY_HANGING_SIGN = ModBlocks.register(func, "mahogany_hanging_sign", (BlockBehaviour.Properties p) -> new CeilingHangingSignBlockBOP(BOPWoodTypes.MAHOGANY, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.MAHOGANY_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.MAHOGANY_WALL_HANGING_SIGN = ModBlocks.register(func, "mahogany_wall_hanging_sign", (BlockBehaviour.Properties p) -> new WallHangingSignBlockBOP(BOPWoodTypes.MAHOGANY, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.MAHOGANY_HANGING_SIGN, true).mapColor(BOPBlocks.MAHOGANY_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.JACARANDA_SAPLING = ModBlocks.register(func, "jacaranda_sapling", (BlockBehaviour.Properties p) -> new SaplingBlockBOP(BOPTreeGrowers.JACARANDA, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).pushReaction(PushReaction.DESTROY).noCollission().randomTicks().instabreak().sound(SoundType.CHERRY_SAPLING));
        BOPBlocks.JACARANDA_LEAVES = ModBlocks.register(func, "jacaranda_leaves", (BlockBehaviour.Properties p) -> new UntintedParticleLeavesBlock(0.05f, (ParticleOptions)ModParticles.JACARANDA_LEAVES, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.COLOR_PURPLE).strength(0.2f).randomTicks().sound(SoundType.CHERRY_LEAVES).noOcclusion().isValidSpawn(ModBlocks::ocelotOrParrot).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never).ignitedByLava().isRedstoneConductor(ModBlocks::never));
        BOPBlocks.JACARANDA_LOG = ModBlocks.register(func, "jacaranda_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.QUARTZ, MapColor.TERRACOTTA_LIGHT_GRAY, SoundType.CHERRY_WOOD));
        BOPBlocks.JACARANDA_WOOD = ModBlocks.register(func, "jacaranda_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_LIGHT_GRAY).strength(2.0f).sound(SoundType.CHERRY_WOOD));
        BOPBlocks.STRIPPED_JACARANDA_LOG = ModBlocks.register(func, "stripped_jacaranda_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.QUARTZ, MapColor.QUARTZ, SoundType.CHERRY_WOOD));
        BOPBlocks.STRIPPED_JACARANDA_WOOD = ModBlocks.register(func, "stripped_jacaranda_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.QUARTZ).strength(2.0f).sound(SoundType.CHERRY_WOOD));
        BOPBlocks.JACARANDA_PLANKS = ModBlocks.register(func, "jacaranda_planks", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.QUARTZ).strength(2.0f, 3.0f).sound(SoundType.CHERRY_WOOD));
        BOPBlocks.JACARANDA_STAIRS = ModBlocks.register(func, "jacaranda_stairs", (BlockBehaviour.Properties p) -> new StairBlock(BOPBlocks.JACARANDA_PLANKS.defaultBlockState(), p), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.JACARANDA_PLANKS));
        BOPBlocks.JACARANDA_SLAB = ModBlocks.register(func, "jacaranda_slab", SlabBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.QUARTZ).strength(2.0f, 3.0f).sound(SoundType.CHERRY_WOOD));
        BOPBlocks.JACARANDA_FENCE = ModBlocks.register(func, "jacaranda_fence", FenceBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.JACARANDA_PLANKS.defaultMapColor()).strength(2.0f, 3.0f).sound(SoundType.CHERRY_WOOD));
        BOPBlocks.JACARANDA_FENCE_GATE = ModBlocks.register(func, "jacaranda_fence_gate", (BlockBehaviour.Properties p) -> new FenceGateBlock(BOPWoodTypes.JACARANDA, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.JACARANDA_PLANKS.defaultMapColor()).strength(2.0f, 3.0f));
        BOPBlocks.JACARANDA_DOOR = ModBlocks.register(func, "jacaranda_door", (BlockBehaviour.Properties p) -> new DoorBlock(BOPBlockSetTypes.JACARANDA, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(BOPBlocks.JACARANDA_PLANKS.defaultMapColor()).strength(3.0f).noOcclusion());
        BOPBlocks.JACARANDA_TRAPDOOR = ModBlocks.register(func, "jacaranda_trapdoor", (BlockBehaviour.Properties p) -> new TrapDoorBlock(BOPBlockSetTypes.JACARANDA, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.QUARTZ).strength(3.0f).noOcclusion());
        BOPBlocks.JACARANDA_PRESSURE_PLATE = ModBlocks.register(func, "jacaranda_pressure_plate", (BlockBehaviour.Properties p) -> new PressurePlateBlock(BOPBlockSetTypes.JACARANDA, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.JACARANDA_PLANKS.defaultMapColor()).noCollission().strength(0.5f));
        BOPBlocks.JACARANDA_BUTTON = ModBlocks.register(func, "jacaranda_button", (BlockBehaviour.Properties p) -> new ButtonBlock(BOPBlockSetTypes.JACARANDA, 30, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).noCollission().strength(0.5f));
        BOPBlocks.JACARANDA_SIGN = ModBlocks.register(func, "jacaranda_sign", (BlockBehaviour.Properties p) -> new StandingSignBlockBOP(BOPWoodTypes.JACARANDA, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.JACARANDA_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.JACARANDA_WALL_SIGN = ModBlocks.register(func, "jacaranda_wall_sign", (BlockBehaviour.Properties p) -> new WallSignBlockBOP(BOPWoodTypes.JACARANDA, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.JACARANDA_SIGN, true).mapColor(BOPBlocks.JACARANDA_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.JACARANDA_HANGING_SIGN = ModBlocks.register(func, "jacaranda_hanging_sign", (BlockBehaviour.Properties p) -> new CeilingHangingSignBlockBOP(BOPWoodTypes.JACARANDA, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.JACARANDA_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.JACARANDA_WALL_HANGING_SIGN = ModBlocks.register(func, "jacaranda_wall_hanging_sign", (BlockBehaviour.Properties p) -> new WallHangingSignBlockBOP(BOPWoodTypes.JACARANDA, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.JACARANDA_HANGING_SIGN, true).mapColor(BOPBlocks.JACARANDA_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.PALM_SAPLING = ModBlocks.register(func, "palm_sapling", (BlockBehaviour.Properties p) -> new SaplingBlockBOP(BOPTreeGrowers.PALM, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).noCollission().randomTicks().instabreak().sound(SoundType.GRASS));
        BOPBlocks.PALM_LEAVES = ModBlocks.register(func, "palm_leaves", (BlockBehaviour.Properties p) -> new TintedParticleLeavesBlock(0.0075f, p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(ModBlocks::ocelotOrParrot).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never).ignitedByLava().isRedstoneConductor(ModBlocks::never));
        BOPBlocks.PALM_LOG = ModBlocks.register(func, "palm_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.TERRACOTTA_YELLOW, MapColor.PODZOL, SoundType.WOOD));
        BOPBlocks.PALM_WOOD = ModBlocks.register(func, "palm_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.PODZOL).strength(2.0f).sound(SoundType.WOOD));
        BOPBlocks.STRIPPED_PALM_LOG = ModBlocks.register(func, "stripped_palm_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.TERRACOTTA_YELLOW, MapColor.TERRACOTTA_YELLOW, SoundType.WOOD));
        BOPBlocks.STRIPPED_PALM_WOOD = ModBlocks.register(func, "stripped_palm_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_YELLOW).strength(2.0f).sound(SoundType.WOOD));
        BOPBlocks.PALM_PLANKS = ModBlocks.register(func, "palm_planks", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_YELLOW).strength(2.0f, 3.0f).sound(SoundType.WOOD));
        BOPBlocks.PALM_STAIRS = ModBlocks.register(func, "palm_stairs", (BlockBehaviour.Properties p) -> new StairBlock(BOPBlocks.PALM_PLANKS.defaultBlockState(), p), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.PALM_PLANKS));
        BOPBlocks.PALM_SLAB = ModBlocks.register(func, "palm_slab", SlabBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_YELLOW).strength(2.0f, 3.0f).sound(SoundType.WOOD));
        BOPBlocks.PALM_FENCE = ModBlocks.register(func, "palm_fence", FenceBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.PALM_PLANKS.defaultMapColor()).strength(2.0f, 3.0f).sound(SoundType.WOOD));
        BOPBlocks.PALM_FENCE_GATE = ModBlocks.register(func, "palm_fence_gate", (BlockBehaviour.Properties p) -> new FenceGateBlock(BOPWoodTypes.PALM, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.PALM_PLANKS.defaultMapColor()).strength(2.0f, 3.0f));
        BOPBlocks.PALM_DOOR = ModBlocks.register(func, "palm_door", (BlockBehaviour.Properties p) -> new DoorBlock(BOPBlockSetTypes.PALM, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(BOPBlocks.PALM_PLANKS.defaultMapColor()).strength(3.0f).noOcclusion());
        BOPBlocks.PALM_TRAPDOOR = ModBlocks.register(func, "palm_trapdoor", (BlockBehaviour.Properties p) -> new TrapDoorBlock(BOPBlockSetTypes.PALM, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_YELLOW).strength(3.0f).noOcclusion());
        BOPBlocks.PALM_PRESSURE_PLATE = ModBlocks.register(func, "palm_pressure_plate", (BlockBehaviour.Properties p) -> new PressurePlateBlock(BOPBlockSetTypes.PALM, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.PALM_PLANKS.defaultMapColor()).noCollission().strength(0.5f));
        BOPBlocks.PALM_BUTTON = ModBlocks.register(func, "palm_button", (BlockBehaviour.Properties p) -> new ButtonBlock(BOPBlockSetTypes.PALM, 30, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).noCollission().strength(0.5f));
        BOPBlocks.PALM_SIGN = ModBlocks.register(func, "palm_sign", (BlockBehaviour.Properties p) -> new StandingSignBlockBOP(BOPWoodTypes.PALM, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.PALM_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.PALM_WALL_SIGN = ModBlocks.register(func, "palm_wall_sign", (BlockBehaviour.Properties p) -> new WallSignBlockBOP(BOPWoodTypes.PALM, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.PALM_SIGN, true).mapColor(BOPBlocks.PALM_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.PALM_HANGING_SIGN = ModBlocks.register(func, "palm_hanging_sign", (BlockBehaviour.Properties p) -> new CeilingHangingSignBlockBOP(BOPWoodTypes.PALM, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.PALM_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.PALM_WALL_HANGING_SIGN = ModBlocks.register(func, "palm_wall_hanging_sign", (BlockBehaviour.Properties p) -> new WallHangingSignBlockBOP(BOPWoodTypes.PALM, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.PALM_HANGING_SIGN, true).mapColor(BOPBlocks.PALM_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.WILLOW_SAPLING = ModBlocks.register(func, "willow_sapling", (BlockBehaviour.Properties p) -> new SaplingBlockBOP(BOPTreeGrowers.WILLOW, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).noCollission().randomTicks().instabreak().sound(SoundType.GRASS));
        BOPBlocks.WILLOW_VINE = ModBlocks.register(func, "willow_vine", VineBlock::new, BlockBehaviour.Properties.of().randomTicks().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).replaceable().ignitedByLava().noCollission().strength(0.2f).sound(SoundType.GRASS));
        BOPBlocks.SPANISH_MOSS = ModBlocks.register(func, "spanish_moss", SpanishMossBottomBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).replaceable().ignitedByLava().randomTicks().noCollission().instabreak().sound(SoundType.GRASS));
        BOPBlocks.SPANISH_MOSS_PLANT = ModBlocks.register(func, "spanish_moss_plant", SpanishMossBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).replaceable().ignitedByLava().noCollission().instabreak().sound(SoundType.GRASS));
        BOPBlocks.WILLOW_LEAVES = ModBlocks.register(func, "willow_leaves", (BlockBehaviour.Properties p) -> new TintedParticleLeavesBlock(0.0075f, p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(ModBlocks::ocelotOrParrot).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never).ignitedByLava().isRedstoneConductor(ModBlocks::never));
        BOPBlocks.WILLOW_LOG = ModBlocks.register(func, "willow_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.TERRACOTTA_LIGHT_GREEN, MapColor.TERRACOTTA_LIGHT_GREEN, SoundType.WOOD));
        BOPBlocks.WILLOW_WOOD = ModBlocks.register(func, "willow_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_LIGHT_GREEN).strength(2.0f).sound(SoundType.WOOD));
        BOPBlocks.STRIPPED_WILLOW_LOG = ModBlocks.register(func, "stripped_willow_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.TERRACOTTA_LIGHT_GREEN, MapColor.TERRACOTTA_LIGHT_GREEN, SoundType.WOOD));
        BOPBlocks.STRIPPED_WILLOW_WOOD = ModBlocks.register(func, "stripped_willow_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_LIGHT_GREEN).strength(2.0f).sound(SoundType.WOOD));
        BOPBlocks.WILLOW_PLANKS = ModBlocks.register(func, "willow_planks", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_LIGHT_GREEN).strength(2.0f, 3.0f).sound(SoundType.WOOD));
        BOPBlocks.WILLOW_STAIRS = ModBlocks.register(func, "willow_stairs", (BlockBehaviour.Properties p) -> new StairBlock(BOPBlocks.WILLOW_PLANKS.defaultBlockState(), p), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.WILLOW_PLANKS));
        BOPBlocks.WILLOW_SLAB = ModBlocks.register(func, "willow_slab", SlabBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_LIGHT_GREEN).strength(2.0f, 3.0f).sound(SoundType.WOOD));
        BOPBlocks.WILLOW_FENCE = ModBlocks.register(func, "willow_fence", FenceBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.WILLOW_PLANKS.defaultMapColor()).strength(2.0f, 3.0f).sound(SoundType.WOOD));
        BOPBlocks.WILLOW_FENCE_GATE = ModBlocks.register(func, "willow_fence_gate", (BlockBehaviour.Properties p) -> new FenceGateBlock(BOPWoodTypes.WILLOW, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.WILLOW_PLANKS.defaultMapColor()).strength(2.0f, 3.0f));
        BOPBlocks.WILLOW_DOOR = ModBlocks.register(func, "willow_door", (BlockBehaviour.Properties p) -> new DoorBlock(BOPBlockSetTypes.WILLOW, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(BOPBlocks.WILLOW_PLANKS.defaultMapColor()).strength(3.0f).noOcclusion());
        BOPBlocks.WILLOW_TRAPDOOR = ModBlocks.register(func, "willow_trapdoor", (BlockBehaviour.Properties p) -> new TrapDoorBlock(BOPBlockSetTypes.WILLOW, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_LIGHT_GREEN).strength(3.0f).noOcclusion());
        BOPBlocks.WILLOW_PRESSURE_PLATE = ModBlocks.register(func, "willow_pressure_plate", (BlockBehaviour.Properties p) -> new PressurePlateBlock(BOPBlockSetTypes.WILLOW, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.WILLOW_PLANKS.defaultMapColor()).noCollission().strength(0.5f));
        BOPBlocks.WILLOW_BUTTON = ModBlocks.register(func, "willow_button", (BlockBehaviour.Properties p) -> new ButtonBlock(BOPBlockSetTypes.WILLOW, 30, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).noCollission().strength(0.5f));
        BOPBlocks.WILLOW_SIGN = ModBlocks.register(func, "willow_sign", (BlockBehaviour.Properties p) -> new StandingSignBlockBOP(BOPWoodTypes.WILLOW, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.WILLOW_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.WILLOW_WALL_SIGN = ModBlocks.register(func, "willow_wall_sign", (BlockBehaviour.Properties p) -> new WallSignBlockBOP(BOPWoodTypes.WILLOW, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.WILLOW_SIGN, true).mapColor(BOPBlocks.WILLOW_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.WILLOW_HANGING_SIGN = ModBlocks.register(func, "willow_hanging_sign", (BlockBehaviour.Properties p) -> new CeilingHangingSignBlockBOP(BOPWoodTypes.WILLOW, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.WILLOW_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.WILLOW_WALL_HANGING_SIGN = ModBlocks.register(func, "willow_wall_hanging_sign", (BlockBehaviour.Properties p) -> new WallHangingSignBlockBOP(BOPWoodTypes.WILLOW, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.WILLOW_HANGING_SIGN, true).mapColor(BOPBlocks.WILLOW_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.DEAD_SAPLING = ModBlocks.register(func, "dead_sapling", (BlockBehaviour.Properties p) -> new SaplingBlockBOP(BOPTreeGrowers.DEAD, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).pushReaction(PushReaction.DESTROY).noCollission().randomTicks().instabreak().sound(SoundType.GRASS));
        BOPBlocks.DEAD_BRANCH = ModBlocks.register(func, "dead_branch", DeadBranchBlock::new, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.COLOR_GRAY).ignitedByLava().noCollission().instabreak().sound(SoundType.WOOD));
        BOPBlocks.DEAD_LEAVES = ModBlocks.register(func, "dead_leaves", (BlockBehaviour.Properties p) -> new TintedParticleLeavesBlock(0.01f, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.WOOD).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(ModBlocks::ocelotOrParrot).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never).ignitedByLava().isRedstoneConductor(ModBlocks::never));
        BOPBlocks.DEAD_LOG = ModBlocks.register(func, "dead_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.STONE, MapColor.COLOR_GRAY, SoundType.WOOD));
        BOPBlocks.DEAD_WOOD = ModBlocks.register(func, "dead_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.COLOR_GRAY).strength(2.0f).sound(SoundType.WOOD));
        BOPBlocks.STRIPPED_DEAD_LOG = ModBlocks.register(func, "stripped_dead_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.STONE, MapColor.STONE, SoundType.WOOD));
        BOPBlocks.STRIPPED_DEAD_WOOD = ModBlocks.register(func, "stripped_dead_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.STONE).strength(2.0f).sound(SoundType.WOOD));
        BOPBlocks.DEAD_PLANKS = ModBlocks.register(func, "dead_planks", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.STONE).strength(2.0f, 3.0f).sound(SoundType.WOOD));
        BOPBlocks.DEAD_STAIRS = ModBlocks.register(func, "dead_stairs", (BlockBehaviour.Properties p) -> new StairBlock(BOPBlocks.DEAD_PLANKS.defaultBlockState(), p), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.DEAD_PLANKS));
        BOPBlocks.DEAD_SLAB = ModBlocks.register(func, "dead_slab", SlabBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.STONE).strength(2.0f, 3.0f).sound(SoundType.WOOD));
        BOPBlocks.DEAD_FENCE = ModBlocks.register(func, "dead_fence", FenceBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.DEAD_PLANKS.defaultMapColor()).strength(2.0f, 3.0f).sound(SoundType.WOOD));
        BOPBlocks.DEAD_FENCE_GATE = ModBlocks.register(func, "dead_fence_gate", (BlockBehaviour.Properties p) -> new FenceGateBlock(BOPWoodTypes.DEAD, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.DEAD_PLANKS.defaultMapColor()).strength(2.0f, 3.0f));
        BOPBlocks.DEAD_DOOR = ModBlocks.register(func, "dead_door", (BlockBehaviour.Properties p) -> new DoorBlock(BOPBlockSetTypes.DEAD, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(BOPBlocks.DEAD_PLANKS.defaultMapColor()).strength(3.0f).noOcclusion());
        BOPBlocks.DEAD_TRAPDOOR = ModBlocks.register(func, "dead_trapdoor", (BlockBehaviour.Properties p) -> new TrapDoorBlock(BOPBlockSetTypes.DEAD, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.STONE).strength(3.0f).noOcclusion());
        BOPBlocks.DEAD_PRESSURE_PLATE = ModBlocks.register(func, "dead_pressure_plate", (BlockBehaviour.Properties p) -> new PressurePlateBlock(BOPBlockSetTypes.DEAD, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.DEAD_PLANKS.defaultMapColor()).noCollission().strength(0.5f));
        BOPBlocks.DEAD_BUTTON = ModBlocks.register(func, "dead_button", (BlockBehaviour.Properties p) -> new ButtonBlock(BOPBlockSetTypes.DEAD, 30, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).noCollission().strength(0.5f));
        BOPBlocks.DEAD_SIGN = ModBlocks.register(func, "dead_sign", (BlockBehaviour.Properties p) -> new StandingSignBlockBOP(BOPWoodTypes.DEAD, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.DEAD_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.DEAD_WALL_SIGN = ModBlocks.register(func, "dead_wall_sign", (BlockBehaviour.Properties p) -> new WallSignBlockBOP(BOPWoodTypes.DEAD, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.DEAD_SIGN, true).mapColor(BOPBlocks.DEAD_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.DEAD_HANGING_SIGN = ModBlocks.register(func, "dead_hanging_sign", (BlockBehaviour.Properties p) -> new CeilingHangingSignBlockBOP(BOPWoodTypes.DEAD, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.DEAD_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.DEAD_WALL_HANGING_SIGN = ModBlocks.register(func, "dead_wall_hanging_sign", (BlockBehaviour.Properties p) -> new WallHangingSignBlockBOP(BOPWoodTypes.DEAD, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.DEAD_HANGING_SIGN, true).mapColor(BOPBlocks.DEAD_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.MAGIC_SAPLING = ModBlocks.register(func, "magic_sapling", (BlockBehaviour.Properties p) -> new SaplingBlockBOP(BOPTreeGrowers.MAGIC, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).pushReaction(PushReaction.DESTROY).noCollission().randomTicks().instabreak().sound(SoundType.CHERRY_SAPLING));
        BOPBlocks.MAGIC_LEAVES = ModBlocks.register(func, "magic_leaves", (BlockBehaviour.Properties p) -> new UntintedParticleLeavesBlock(0.01f, (ParticleOptions)ModParticles.MAGIC_LEAVES, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.COLOR_CYAN).strength(0.2f).randomTicks().sound(SoundType.CHERRY_LEAVES).noOcclusion().isValidSpawn(ModBlocks::ocelotOrParrot).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never).ignitedByLava().isRedstoneConductor(ModBlocks::never));
        BOPBlocks.MAGIC_LOG = ModBlocks.register(func, "magic_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.COLOR_BLUE, MapColor.TERRACOTTA_LIGHT_BLUE, SoundType.CHERRY_WOOD));
        BOPBlocks.MAGIC_WOOD = ModBlocks.register(func, "magic_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_LIGHT_BLUE).strength(2.0f).sound(SoundType.CHERRY_WOOD));
        BOPBlocks.STRIPPED_MAGIC_LOG = ModBlocks.register(func, "stripped_magic_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.COLOR_BLUE, MapColor.COLOR_BLUE, SoundType.CHERRY_WOOD));
        BOPBlocks.STRIPPED_MAGIC_WOOD = ModBlocks.register(func, "stripped_magic_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.COLOR_BLUE).strength(2.0f).sound(SoundType.CHERRY_WOOD));
        BOPBlocks.MAGIC_PLANKS = ModBlocks.register(func, "magic_planks", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.COLOR_BLUE).strength(2.0f, 3.0f).sound(SoundType.CHERRY_WOOD));
        BOPBlocks.MAGIC_STAIRS = ModBlocks.register(func, "magic_stairs", (BlockBehaviour.Properties p) -> new StairBlock(BOPBlocks.MAGIC_PLANKS.defaultBlockState(), p), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.MAGIC_PLANKS));
        BOPBlocks.MAGIC_SLAB = ModBlocks.register(func, "magic_slab", SlabBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.COLOR_BLUE).strength(2.0f, 3.0f).sound(SoundType.CHERRY_WOOD));
        BOPBlocks.MAGIC_FENCE = ModBlocks.register(func, "magic_fence", FenceBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.MAGIC_PLANKS.defaultMapColor()).strength(2.0f, 3.0f).sound(SoundType.CHERRY_WOOD));
        BOPBlocks.MAGIC_FENCE_GATE = ModBlocks.register(func, "magic_fence_gate", (BlockBehaviour.Properties p) -> new FenceGateBlock(BOPWoodTypes.MAGIC, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.MAGIC_PLANKS.defaultMapColor()).strength(2.0f, 3.0f));
        BOPBlocks.MAGIC_DOOR = ModBlocks.register(func, "magic_door", (BlockBehaviour.Properties p) -> new DoorBlock(BOPBlockSetTypes.MAGIC, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(BOPBlocks.MAGIC_PLANKS.defaultMapColor()).strength(3.0f).noOcclusion());
        BOPBlocks.MAGIC_TRAPDOOR = ModBlocks.register(func, "magic_trapdoor", (BlockBehaviour.Properties p) -> new TrapDoorBlock(BOPBlockSetTypes.MAGIC, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.COLOR_BLUE).strength(3.0f).noOcclusion());
        BOPBlocks.MAGIC_PRESSURE_PLATE = ModBlocks.register(func, "magic_pressure_plate", (BlockBehaviour.Properties p) -> new PressurePlateBlock(BOPBlockSetTypes.MAGIC, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.MAGIC_PLANKS.defaultMapColor()).noCollission().strength(0.5f));
        BOPBlocks.MAGIC_BUTTON = ModBlocks.register(func, "magic_button", (BlockBehaviour.Properties p) -> new ButtonBlock(BOPBlockSetTypes.MAGIC, 30, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).noCollission().strength(0.5f));
        BOPBlocks.MAGIC_SIGN = ModBlocks.register(func, "magic_sign", (BlockBehaviour.Properties p) -> new StandingSignBlockBOP(BOPWoodTypes.MAGIC, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.MAGIC_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().noCollission().forceSolidOn().strength(1.0f));
        BOPBlocks.MAGIC_WALL_SIGN = ModBlocks.register(func, "magic_wall_sign", (BlockBehaviour.Properties p) -> new WallSignBlockBOP(BOPWoodTypes.MAGIC, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.MAGIC_SIGN, true).mapColor(BOPBlocks.MAGIC_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().noCollission().forceSolidOn().strength(1.0f));
        BOPBlocks.MAGIC_HANGING_SIGN = ModBlocks.register(func, "magic_hanging_sign", (BlockBehaviour.Properties p) -> new CeilingHangingSignBlockBOP(BOPWoodTypes.MAGIC, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.MAGIC_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.MAGIC_WALL_HANGING_SIGN = ModBlocks.register(func, "magic_wall_hanging_sign", (BlockBehaviour.Properties p) -> new WallHangingSignBlockBOP(BOPWoodTypes.MAGIC, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.MAGIC_HANGING_SIGN, true).mapColor(BOPBlocks.MAGIC_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.UMBRAN_SAPLING = ModBlocks.register(func, "umbran_sapling", (BlockBehaviour.Properties p) -> new SaplingBlockBOP(BOPTreeGrowers.UMBRAN, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_BLUE).pushReaction(PushReaction.DESTROY).noCollission().randomTicks().instabreak().sound(SoundType.GRASS));
        BOPBlocks.UMBRAN_LEAVES = ModBlocks.register(func, "umbran_leaves", (BlockBehaviour.Properties p) -> new UntintedParticleLeavesBlock(0.0025f, (ParticleOptions)ModParticles.UMBRAN_LEAVES, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.TERRACOTTA_BLUE).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(ModBlocks::ocelotOrParrot).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never).ignitedByLava().isRedstoneConductor(ModBlocks::never));
        BOPBlocks.UMBRAN_LOG = ModBlocks.register(func, "umbran_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.TERRACOTTA_BLUE, MapColor.TERRACOTTA_BLUE, SoundType.NETHER_WOOD));
        BOPBlocks.UMBRAN_WOOD = ModBlocks.register(func, "umbran_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_BLUE).strength(2.0f).sound(SoundType.NETHER_WOOD));
        BOPBlocks.STRIPPED_UMBRAN_LOG = ModBlocks.register(func, "stripped_umbran_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.TERRACOTTA_BLUE, MapColor.TERRACOTTA_BLUE, SoundType.NETHER_WOOD));
        BOPBlocks.STRIPPED_UMBRAN_WOOD = ModBlocks.register(func, "stripped_umbran_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_BLUE).strength(2.0f).sound(SoundType.NETHER_WOOD));
        BOPBlocks.UMBRAN_PLANKS = ModBlocks.register(func, "umbran_planks", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_BLUE).strength(2.0f, 3.0f).sound(SoundType.NETHER_WOOD));
        BOPBlocks.UMBRAN_STAIRS = ModBlocks.register(func, "umbran_stairs", (BlockBehaviour.Properties p) -> new StairBlock(BOPBlocks.UMBRAN_PLANKS.defaultBlockState(), p), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.UMBRAN_PLANKS));
        BOPBlocks.UMBRAN_SLAB = ModBlocks.register(func, "umbran_slab", SlabBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_BLUE).strength(2.0f, 3.0f).sound(SoundType.NETHER_WOOD));
        BOPBlocks.UMBRAN_FENCE = ModBlocks.register(func, "umbran_fence", FenceBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.UMBRAN_PLANKS.defaultMapColor()).strength(2.0f, 3.0f).sound(SoundType.NETHER_WOOD));
        BOPBlocks.UMBRAN_FENCE_GATE = ModBlocks.register(func, "umbran_fence_gate", (BlockBehaviour.Properties p) -> new FenceGateBlock(BOPWoodTypes.UMBRAN, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.UMBRAN_PLANKS.defaultMapColor()).strength(2.0f, 3.0f));
        BOPBlocks.UMBRAN_DOOR = ModBlocks.register(func, "umbran_door", (BlockBehaviour.Properties p) -> new DoorBlock(BOPBlockSetTypes.UMBRAN, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(BOPBlocks.UMBRAN_PLANKS.defaultMapColor()).strength(3.0f).noOcclusion());
        BOPBlocks.UMBRAN_TRAPDOOR = ModBlocks.register(func, "umbran_trapdoor", (BlockBehaviour.Properties p) -> new TrapDoorBlock(BOPBlockSetTypes.UMBRAN, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.TERRACOTTA_BLUE).strength(3.0f).noOcclusion());
        BOPBlocks.UMBRAN_PRESSURE_PLATE = ModBlocks.register(func, "umbran_pressure_plate", (BlockBehaviour.Properties p) -> new PressurePlateBlock(BOPBlockSetTypes.UMBRAN, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.UMBRAN_PLANKS.defaultMapColor()).noCollission().strength(0.5f));
        BOPBlocks.UMBRAN_BUTTON = ModBlocks.register(func, "umbran_button", (BlockBehaviour.Properties p) -> new ButtonBlock(BOPBlockSetTypes.UMBRAN, 30, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).noCollission().strength(0.5f));
        BOPBlocks.UMBRAN_SIGN = ModBlocks.register(func, "umbran_sign", (BlockBehaviour.Properties p) -> new StandingSignBlockBOP(BOPWoodTypes.UMBRAN, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.UMBRAN_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.UMBRAN_WALL_SIGN = ModBlocks.register(func, "umbran_wall_sign", (BlockBehaviour.Properties p) -> new WallSignBlockBOP(BOPWoodTypes.UMBRAN, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.UMBRAN_SIGN, true).mapColor(BOPBlocks.UMBRAN_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.UMBRAN_HANGING_SIGN = ModBlocks.register(func, "umbran_hanging_sign", (BlockBehaviour.Properties p) -> new CeilingHangingSignBlockBOP(BOPWoodTypes.UMBRAN, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.UMBRAN_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.UMBRAN_WALL_HANGING_SIGN = ModBlocks.register(func, "umbran_wall_hanging_sign", (BlockBehaviour.Properties p) -> new WallHangingSignBlockBOP(BOPWoodTypes.UMBRAN, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.UMBRAN_HANGING_SIGN, true).mapColor(BOPBlocks.UMBRAN_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.HELLBARK_SAPLING = ModBlocks.register(func, "hellbark_sapling", (BlockBehaviour.Properties p) -> new SaplingBlockBOP(BOPTreeGrowers.HELLBARK, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_PURPLE).pushReaction(PushReaction.DESTROY).noCollission().randomTicks().instabreak().sound(SoundType.GRASS));
        BOPBlocks.HELLBARK_LEAVES = ModBlocks.register(func, "hellbark_leaves", (BlockBehaviour.Properties p) -> new UntintedParticleLeavesBlock(0.001f, (ParticleOptions)ModParticles.HELLBARK_LEAVES, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.TERRACOTTA_PURPLE).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(ModBlocks::ocelotOrParrot).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never).isRedstoneConductor(ModBlocks::never));
        BOPBlocks.HELLBARK_LOG = ModBlocks.register(func, "hellbark_log", RotatedPillarBlock::new, ModBlocks.logNonIgnitingProperties(MapColor.TERRACOTTA_GRAY, MapColor.COLOR_LIGHT_GRAY, SoundType.NETHER_WOOD));
        BOPBlocks.HELLBARK_WOOD = ModBlocks.register(func, "hellbark_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).mapColor(MapColor.COLOR_LIGHT_GRAY).strength(2.0f).sound(SoundType.NETHER_WOOD));
        BOPBlocks.STRIPPED_HELLBARK_LOG = ModBlocks.register(func, "stripped_hellbark_log", RotatedPillarBlock::new, ModBlocks.logNonIgnitingProperties(MapColor.TERRACOTTA_GRAY, MapColor.TERRACOTTA_GRAY, SoundType.NETHER_WOOD));
        BOPBlocks.STRIPPED_HELLBARK_WOOD = ModBlocks.register(func, "stripped_hellbark_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).mapColor(MapColor.TERRACOTTA_GRAY).strength(2.0f).sound(SoundType.NETHER_WOOD));
        BOPBlocks.HELLBARK_PLANKS = ModBlocks.register(func, "hellbark_planks", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).mapColor(MapColor.TERRACOTTA_GRAY).strength(2.0f, 3.0f).sound(SoundType.NETHER_WOOD));
        BOPBlocks.HELLBARK_STAIRS = ModBlocks.register(func, "hellbark_stairs", (BlockBehaviour.Properties p) -> new StairBlock(BOPBlocks.HELLBARK_PLANKS.defaultBlockState(), p), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.HELLBARK_PLANKS));
        BOPBlocks.HELLBARK_SLAB = ModBlocks.register(func, "hellbark_slab", SlabBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).mapColor(MapColor.TERRACOTTA_GRAY).strength(2.0f, 3.0f).sound(SoundType.NETHER_WOOD));
        BOPBlocks.HELLBARK_FENCE = ModBlocks.register(func, "hellbark_fence", FenceBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).forceSolidOn().mapColor(BOPBlocks.HELLBARK_PLANKS.defaultMapColor()).strength(2.0f, 3.0f).sound(SoundType.NETHER_WOOD));
        BOPBlocks.HELLBARK_FENCE_GATE = ModBlocks.register(func, "hellbark_fence_gate", (BlockBehaviour.Properties p) -> new FenceGateBlock(BOPWoodTypes.HELLBARK, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).forceSolidOn().mapColor(BOPBlocks.HELLBARK_PLANKS.defaultMapColor()).strength(2.0f, 3.0f));
        BOPBlocks.HELLBARK_DOOR = ModBlocks.register(func, "hellbark_door", (BlockBehaviour.Properties p) -> new DoorBlock(BOPBlockSetTypes.HELLBARK, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).mapColor(BOPBlocks.HELLBARK_PLANKS.defaultMapColor()).strength(3.0f).noOcclusion());
        BOPBlocks.HELLBARK_TRAPDOOR = ModBlocks.register(func, "hellbark_trapdoor", (BlockBehaviour.Properties p) -> new TrapDoorBlock(BOPBlockSetTypes.HELLBARK, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).mapColor(MapColor.TERRACOTTA_GRAY).strength(3.0f).noOcclusion());
        BOPBlocks.HELLBARK_PRESSURE_PLATE = ModBlocks.register(func, "hellbark_pressure_plate", (BlockBehaviour.Properties p) -> new PressurePlateBlock(BOPBlockSetTypes.HELLBARK, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).forceSolidOn().mapColor(BOPBlocks.HELLBARK_PLANKS.defaultMapColor()).noCollission().strength(0.5f));
        BOPBlocks.HELLBARK_BUTTON = ModBlocks.register(func, "hellbark_button", (BlockBehaviour.Properties p) -> new ButtonBlock(BOPBlockSetTypes.HELLBARK, 30, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).noCollission().strength(0.5f));
        BOPBlocks.HELLBARK_SIGN = ModBlocks.register(func, "hellbark_sign", (BlockBehaviour.Properties p) -> new StandingSignBlockBOP(BOPWoodTypes.HELLBARK, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.HELLBARK_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.HELLBARK_WALL_SIGN = ModBlocks.register(func, "hellbark_wall_sign", (BlockBehaviour.Properties p) -> new WallSignBlockBOP(BOPWoodTypes.HELLBARK, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.HELLBARK_SIGN, true).mapColor(BOPBlocks.HELLBARK_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.HELLBARK_HANGING_SIGN = ModBlocks.register(func, "hellbark_hanging_sign", (BlockBehaviour.Properties p) -> new CeilingHangingSignBlockBOP(BOPWoodTypes.HELLBARK, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.HELLBARK_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.HELLBARK_WALL_HANGING_SIGN = ModBlocks.register(func, "hellbark_wall_hanging_sign", (BlockBehaviour.Properties p) -> new WallHangingSignBlockBOP(BOPWoodTypes.HELLBARK, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.HELLBARK_HANGING_SIGN, true).mapColor(BOPBlocks.HELLBARK_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.EMPYREAL_SAPLING = ModBlocks.register(func, "empyreal_sapling", (BlockBehaviour.Properties p) -> new SaplingBlockBOP(BOPTreeGrowers.EMPYREAL, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.SAND).pushReaction(PushReaction.DESTROY).noCollission().randomTicks().instabreak().sound(SoundType.GRASS));
        BOPBlocks.EMPYREAL_LEAVES = ModBlocks.register(func, "empyreal_leaves", (BlockBehaviour.Properties p) -> new UntintedParticleLeavesBlock(0.0025f, (ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.TINTED_LEAVES, (int)-5962), p), BlockBehaviour.Properties.of().mapColor(MapColor.SAND).pushReaction(PushReaction.DESTROY).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(ModBlocks::ocelotOrParrot).isSuffocating(ModBlocks::never).isViewBlocking(ModBlocks::never).ignitedByLava().isRedstoneConductor(ModBlocks::never));
        BOPBlocks.EMPYREAL_LOG = ModBlocks.register(func, "empyreal_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.COLOR_PURPLE, MapColor.QUARTZ, SoundType.NETHER_WOOD));
        BOPBlocks.EMPYREAL_WOOD = ModBlocks.register(func, "empyreal_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.QUARTZ).strength(2.0f).sound(SoundType.NETHER_WOOD));
        BOPBlocks.STRIPPED_EMPYREAL_LOG = ModBlocks.register(func, "stripped_empyreal_log", RotatedPillarBlock::new, ModBlocks.logProperties(MapColor.COLOR_PURPLE, MapColor.COLOR_PURPLE, SoundType.NETHER_WOOD));
        BOPBlocks.STRIPPED_EMPYREAL_WOOD = ModBlocks.register(func, "stripped_empyreal_wood", RotatedPillarBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.COLOR_PURPLE).strength(2.0f).sound(SoundType.NETHER_WOOD));
        BOPBlocks.EMPYREAL_PLANKS = ModBlocks.register(func, "empyreal_planks", Block::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.COLOR_PURPLE).strength(2.0f, 3.0f).sound(SoundType.NETHER_WOOD));
        BOPBlocks.EMPYREAL_STAIRS = ModBlocks.register(func, "empyreal_stairs", (BlockBehaviour.Properties p) -> new StairBlock(BOPBlocks.EMPYREAL_PLANKS.defaultBlockState(), p), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)BOPBlocks.EMPYREAL_PLANKS));
        BOPBlocks.EMPYREAL_SLAB = ModBlocks.register(func, "empyreal_slab", SlabBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.COLOR_PURPLE).strength(2.0f, 3.0f).sound(SoundType.NETHER_WOOD));
        BOPBlocks.EMPYREAL_FENCE = ModBlocks.register(func, "empyreal_fence", FenceBlock::new, BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.EMPYREAL_PLANKS.defaultMapColor()).strength(2.0f, 3.0f).sound(SoundType.NETHER_WOOD));
        BOPBlocks.EMPYREAL_FENCE_GATE = ModBlocks.register(func, "empyreal_fence_gate", (BlockBehaviour.Properties p) -> new FenceGateBlock(BOPWoodTypes.EMPYREAL, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.EMPYREAL_PLANKS.defaultMapColor()).strength(2.0f, 3.0f));
        BOPBlocks.EMPYREAL_DOOR = ModBlocks.register(func, "empyreal_door", (BlockBehaviour.Properties p) -> new DoorBlock(BOPBlockSetTypes.EMPYREAL, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(BOPBlocks.EMPYREAL_PLANKS.defaultMapColor()).strength(3.0f).noOcclusion());
        BOPBlocks.EMPYREAL_TRAPDOOR = ModBlocks.register(func, "empyreal_trapdoor", (BlockBehaviour.Properties p) -> new TrapDoorBlock(BOPBlockSetTypes.EMPYREAL, p), BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(MapColor.COLOR_PURPLE).strength(3.0f).noOcclusion());
        BOPBlocks.EMPYREAL_PRESSURE_PLATE = ModBlocks.register(func, "empyreal_pressure_plate", (BlockBehaviour.Properties p) -> new PressurePlateBlock(BOPBlockSetTypes.EMPYREAL, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().mapColor(BOPBlocks.EMPYREAL_PLANKS.defaultMapColor()).noCollission().strength(0.5f));
        BOPBlocks.EMPYREAL_BUTTON = ModBlocks.register(func, "empyreal_button", (BlockBehaviour.Properties p) -> new ButtonBlock(BOPBlockSetTypes.EMPYREAL, 30, p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).noCollission().strength(0.5f));
        BOPBlocks.EMPYREAL_SIGN = ModBlocks.register(func, "empyreal_sign", (BlockBehaviour.Properties p) -> new StandingSignBlockBOP(BOPWoodTypes.EMPYREAL, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.EMPYREAL_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.EMPYREAL_WALL_SIGN = ModBlocks.register(func, "empyreal_wall_sign", (BlockBehaviour.Properties p) -> new WallSignBlockBOP(BOPWoodTypes.EMPYREAL, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.EMPYREAL_SIGN, true).mapColor(BOPBlocks.EMPYREAL_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.EMPYREAL_HANGING_SIGN = ModBlocks.register(func, "empyreal_hanging_sign", (BlockBehaviour.Properties p) -> new CeilingHangingSignBlockBOP(BOPWoodTypes.EMPYREAL, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(BOPBlocks.EMPYREAL_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.EMPYREAL_WALL_HANGING_SIGN = ModBlocks.register(func, "empyreal_wall_hanging_sign", (BlockBehaviour.Properties p) -> new WallHangingSignBlockBOP(BOPWoodTypes.EMPYREAL, (BlockBehaviour.Properties)p), ModBlocks.wallVariant(BOPBlocks.EMPYREAL_HANGING_SIGN, true).mapColor(BOPBlocks.EMPYREAL_PLANKS.defaultMapColor()).instrument(NoteBlockInstrument.BASS).ignitedByLava().forceSolidOn().noCollission().strength(1.0f));
        BOPBlocks.ROSE = ModBlocks.register(func, "rose", (BlockBehaviour.Properties p) -> new FlowerBlockBOP((Holder<MobEffect>)MobEffects.SLOWNESS, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.VIOLET = ModBlocks.register(func, "violet", (BlockBehaviour.Properties p) -> new FlowerBlockBOP((Holder<MobEffect>)MobEffects.NAUSEA, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.LAVENDER = ModBlocks.register(func, "lavender", (BlockBehaviour.Properties p) -> new FlowerBlockBOP((Holder<MobEffect>)MobEffects.HEALTH_BOOST, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.COLOR_MAGENTA).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.TALL_LAVENDER = ModBlocks.register(func, "tall_lavender", TallFlowerBlockBOP::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.WHITE_LAVENDER = ModBlocks.register(func, "white_lavender", (BlockBehaviour.Properties p) -> new FlowerBlockBOP((Holder<MobEffect>)MobEffects.HEALTH_BOOST, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.SNOW).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.TALL_WHITE_LAVENDER = ModBlocks.register(func, "tall_white_lavender", TallFlowerBlockBOP::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.BLUE_HYDRANGEA = ModBlocks.register(func, "blue_hydrangea", TallFlowerBlockBOP::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.GOLDENROD = ModBlocks.register(func, "goldenrod", TallFlowerBlockBOP::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.ORANGE_COSMOS = ModBlocks.register(func, "orange_cosmos", (BlockBehaviour.Properties p) -> new FlowerBlockBOP((Holder<MobEffect>)MobEffects.ABSORPTION, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.PINK_DAFFODIL = ModBlocks.register(func, "pink_daffodil", (BlockBehaviour.Properties p) -> new FlowerBlockBOP((Holder<MobEffect>)MobEffects.INVISIBILITY, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.PINK_HIBISCUS = ModBlocks.register(func, "pink_hibiscus", (BlockBehaviour.Properties p) -> new FlowerBlockBOP((Holder<MobEffect>)MobEffects.REGENERATION, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.PURPLE_WILDFLOWERS = ModBlocks.register(func, "purple_wildflowers", PurpleWildflowerBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().sound(SoundType.PINK_PETALS).pushReaction(PushReaction.DESTROY));
        BOPBlocks.WHITE_PETALS = ModBlocks.register(func, "white_petals", FlowerBedBlockBOP::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().sound(SoundType.PINK_PETALS).pushReaction(PushReaction.DESTROY));
        BOPBlocks.ICY_IRIS = ModBlocks.register(func, "icy_iris", TallFlowerBlockBOP::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.GLOWFLOWER = ModBlocks.register(func, "glowflower", (BlockBehaviour.Properties p) -> new FlowerBlockBOP((Holder<MobEffect>)MobEffects.GLOWING, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).lightLevel(state -> 9));
        BOPBlocks.WILTED_LILY = ModBlocks.register(func, "wilted_lily", (BlockBehaviour.Properties p) -> new FlowerBlockBOP((Holder<MobEffect>)MobEffects.UNLUCK, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.BURNING_BLOSSOM = ModBlocks.register(func, "burning_blossom", (BlockBehaviour.Properties p) -> new FlowerBlockBOP((Holder<MobEffect>)MobEffects.FIRE_RESISTANCE, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).lightLevel(state -> 7));
        BOPBlocks.ENDBLOOM = ModBlocks.register(func, "endbloom", (BlockBehaviour.Properties p) -> new FlowerBlockBOP((Holder<MobEffect>)MobEffects.WATER_BREATHING, (BlockBehaviour.Properties)p), BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_YELLOW).pushReaction(PushReaction.DESTROY).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.SPROUT = ModBlocks.register(func, "sprout", FoliageBlockBOP::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).replaceable().ignitedByLava().noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XYZ));
        BOPBlocks.HIGH_GRASS = ModBlocks.register(func, "high_grass", HighGrassBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).randomTicks().replaceable().ignitedByLava().noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.HIGH_GRASS_PLANT = ModBlocks.register(func, "high_grass_plant", HighGrassPlantBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).replaceable().ignitedByLava().noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.CLOVER = ModBlocks.register(func, "clover", CloverBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).replaceable().ignitedByLava().noCollission().sound(SoundType.PINK_PETALS).pushReaction(PushReaction.DESTROY));
        BOPBlocks.HUGE_CLOVER_PETAL = ModBlocks.register(func, "huge_clover_petal", HugeCloverPetalBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).ignitedByLava().instabreak().sound(SoundType.PINK_PETALS));
        BOPBlocks.HUGE_LILY_PAD = ModBlocks.register(func, "huge_lily_pad", HugeLilyPadBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).instabreak().sound(SoundType.LILY_PAD).noOcclusion());
        BOPBlocks.WATERLILY = ModBlocks.register(func, "waterlily", WaterlilyBlockBOP::new, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.COLOR_PINK).noOcclusion().noCollission().instabreak().sound(SoundType.LILY_PAD).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.DUNE_GRASS = ModBlocks.register(func, "dune_grass", FoliageBlockBOP::new, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.TERRACOTTA_LIGHT_GREEN).replaceable().ignitedByLava().noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XYZ));
        BOPBlocks.DESERT_GRASS = ModBlocks.register(func, "desert_grass", FoliageBlockBOP::new, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.TERRACOTTA_ORANGE).replaceable().ignitedByLava().noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XYZ));
        BOPBlocks.DEAD_GRASS = ModBlocks.register(func, "dead_grass", FoliageBlockBOP::new, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.WOOD).replaceable().ignitedByLava().noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XYZ));
        BOPBlocks.TUNDRA_SHRUB = ModBlocks.register(func, "tundra_shrub", FoliageBlockBOP::new, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.PLANT).replaceable().ignitedByLava().noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.ENDERPHYTE = ModBlocks.register(func, "enderphyte", FoliageBlockBOP::new, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.TERRACOTTA_YELLOW).replaceable().ignitedByLava().noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XYZ));
        BOPBlocks.LUMALOOP = ModBlocks.register(func, "lumaloop", LumaloopBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_YELLOW).pushReaction(PushReaction.DESTROY).randomTicks().replaceable().ignitedByLava().noCollission().instabreak().sound(SoundType.GRASS).lightLevel(LumaloopBlock.lightLevel(10)).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.LUMALOOP_PLANT = ModBlocks.register(func, "lumaloop_plant", LumaloopPlantBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_YELLOW).pushReaction(PushReaction.DESTROY).replaceable().ignitedByLava().noCollission().instabreak().sound(SoundType.GRASS).lightLevel(LumaloopPlantBlock.lightLevel(10)).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.BARLEY = ModBlocks.register(func, "barley", DoublePlantBlockBOP::new, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.TERRACOTTA_YELLOW).ignitedByLava().noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.SEA_OATS = ModBlocks.register(func, "sea_oats", SeaOatsBlock::new, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.SAND).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.CATTAIL = ModBlocks.register(func, "cattail", DoubleWatersidePlantBlock::new, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.DIRT).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.REED = ModBlocks.register(func, "reed", DoubleWaterPlantBlock::new, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.DIRT).replaceable().noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.WATERGRASS = ModBlocks.register(func, "watergrass", DoubleWaterPlantBlock::new, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.PLANT).replaceable().noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.TINY_CACTUS = ModBlocks.register(func, "tiny_cactus", TinyCactusBlock::new, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.PLANT).noCollission().instabreak().sound(SoundType.WOOL).offsetType(BlockBehaviour.OffsetType.XZ));
        BOPBlocks.BRAMBLE = ModBlocks.register(func, "bramble", BrambleBlock::new, BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).mapColor(MapColor.NETHER).strength(0.4f).sound(SoundType.WOOD));
        BOPBlocks.BRAMBLE_LEAVES = ModBlocks.register(func, "bramble_leaves", BrambleLeavesBlock::new, BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).mapColor(MapColor.PLANT).instabreak().sound(SoundType.GRASS));
        BOPBlocks.POTTED_ORIGIN_SAPLING = ModBlocks.register(func, "potted_origin_sapling", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.ORIGIN_SAPLING, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_FLOWERING_OAK_SAPLING = ModBlocks.register(func, "potted_flowering_oak_sapling", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.FLOWERING_OAK_SAPLING, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_CYPRESS_SAPLING = ModBlocks.register(func, "potted_cypress_sapling", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.CYPRESS_SAPLING, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_SNOWBLOSSOM_SAPLING = ModBlocks.register(func, "potted_snowblossom_sapling", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.SNOWBLOSSOM_SAPLING, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_RAINBOW_BIRCH_SAPLING = ModBlocks.register(func, "potted_rainbow_birch_sapling", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.RAINBOW_BIRCH_SAPLING, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak().lightLevel(state -> 5));
        BOPBlocks.POTTED_FIR_SAPLING = ModBlocks.register(func, "potted_fir_sapling", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.FIR_SAPLING, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_PINE_SAPLING = ModBlocks.register(func, "potted_pine_sapling", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.PINE_SAPLING, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_RED_MAPLE_SAPLING = ModBlocks.register(func, "potted_red_maple_sapling", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.RED_MAPLE_SAPLING, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_ORANGE_MAPLE_SAPLING = ModBlocks.register(func, "potted_orange_maple_sapling", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.ORANGE_MAPLE_SAPLING, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_YELLOW_MAPLE_SAPLING = ModBlocks.register(func, "potted_yellow_maple_sapling", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.YELLOW_MAPLE_SAPLING, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_REDWOOD_SAPLING = ModBlocks.register(func, "potted_redwood_sapling", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.REDWOOD_SAPLING, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_MAHOGANY_SAPLING = ModBlocks.register(func, "potted_mahogany_sapling", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.MAHOGANY_SAPLING, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_JACARANDA_SAPLING = ModBlocks.register(func, "potted_jacaranda_sapling", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.JACARANDA_SAPLING, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_PALM_SAPLING = ModBlocks.register(func, "potted_palm_sapling", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.PALM_SAPLING, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_WILLOW_SAPLING = ModBlocks.register(func, "potted_willow_sapling", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.WILLOW_SAPLING, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_DEAD_SAPLING = ModBlocks.register(func, "potted_dead_sapling", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.DEAD_SAPLING, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_MAGIC_SAPLING = ModBlocks.register(func, "potted_magic_sapling", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.MAGIC_SAPLING, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_UMBRAN_SAPLING = ModBlocks.register(func, "potted_umbran_sapling", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.UMBRAN_SAPLING, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_HELLBARK_SAPLING = ModBlocks.register(func, "potted_hellbark_sapling", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.HELLBARK_SAPLING, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_EMPYREAL_SAPLING = ModBlocks.register(func, "potted_empyreal_sapling", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.EMPYREAL_SAPLING, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_ROSE = ModBlocks.register(func, "potted_rose", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.ROSE, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_VIOLET = ModBlocks.register(func, "potted_violet", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.VIOLET, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_LAVENDER = ModBlocks.register(func, "potted_lavender", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.LAVENDER, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_WHITE_LAVENDER = ModBlocks.register(func, "potted_white_lavender", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.WHITE_LAVENDER, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_ORANGE_COSMOS = ModBlocks.register(func, "potted_orange_cosmos", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.ORANGE_COSMOS, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_PINK_DAFFODIL = ModBlocks.register(func, "potted_pink_daffodil", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.PINK_DAFFODIL, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_PINK_HIBISCUS = ModBlocks.register(func, "potted_pink_hibiscus", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.PINK_HIBISCUS, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_GLOWFLOWER = ModBlocks.register(func, "potted_glowflower", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.GLOWFLOWER, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak().lightLevel(state -> 9));
        BOPBlocks.POTTED_WILTED_LILY = ModBlocks.register(func, "potted_wilted_lily", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.WILTED_LILY, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_BURNING_BLOSSOM = ModBlocks.register(func, "potted_burning_blossom", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.BURNING_BLOSSOM, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak().lightLevel(state -> 7));
        BOPBlocks.POTTED_ENDBLOOM = ModBlocks.register(func, "potted_endbloom", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.ENDBLOOM, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_SPROUT = ModBlocks.register(func, "potted_sprout", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.SPROUT, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_TINY_CACTUS = ModBlocks.register(func, "potted_tiny_cactus", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.TINY_CACTUS, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_TOADSTOOL = ModBlocks.register(func, "potted_toadstool", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.TOADSTOOL, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak());
        BOPBlocks.POTTED_GLOWSHROOM = ModBlocks.register(func, "potted_glowshroom", (BlockBehaviour.Properties p) -> new FlowerPotBlock(BOPBlocks.GLOWSHROOM, p), BlockBehaviour.Properties.of().noOcclusion().pushReaction(PushReaction.DESTROY).instabreak().lightLevel(state -> 3));
    }

    private static BlockBehaviour.Properties logProperties(MapColor MapColor2, MapColor MapColor22, SoundType soundType) {
        return BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).ignitedByLava().mapColor(blockState -> blockState.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? MapColor2 : MapColor22).strength(2.0f).sound(soundType);
    }

    private static BlockBehaviour.Properties logNonIgnitingProperties(MapColor MapColor2, MapColor MapColor22, SoundType soundType) {
        return BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).mapColor(blockState -> blockState.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? MapColor2 : MapColor22).strength(2.0f).sound(soundType);
    }

    private static BlockBehaviour.Properties wallVariant(Block block, boolean p_368625_) {
        BlockBehaviour.Properties blockbehaviour$properties = block.properties();
        BlockBehaviour.Properties blockbehaviour$properties1 = BlockBehaviour.Properties.of().overrideLootTable(block.getLootTable());
        if (p_368625_) {
            blockbehaviour$properties1 = blockbehaviour$properties1.overrideDescription(block.getDescriptionId());
        }
        return blockbehaviour$properties1;
    }

    private static Block register(BiConsumer<ResourceLocation, Block> func, ResourceKey<Block> key, Function<BlockBehaviour.Properties, Block> factory, BlockBehaviour.Properties properties) {
        Block block = factory.apply(properties.setId(key));
        func.accept(key.location(), block);
        return block;
    }

    private static Block register(BiConsumer<ResourceLocation, Block> func, String name, Function<BlockBehaviour.Properties, Block> factory, BlockBehaviour.Properties properties) {
        return ModBlocks.register(func, ModBlocks.blockId(name), factory, properties);
    }

    private static ResourceKey<Block> blockId(String name) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"biomesoplenty", (String)name));
    }

    private static Boolean never(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return false;
    }

    private static Boolean ocelotOrParrot(BlockState p_50822_, BlockGetter p_50823_, BlockPos p_50824_, EntityType<?> p_50825_) {
        return p_50825_ == EntityType.OCELOT || p_50825_ == EntityType.PARROT;
    }
}

